package cn.zzq0324.radish.components.wechat.officialaccount.api;

import cn.zzq0324.radish.components.http.constant.HttpMethodType;
import cn.zzq0324.radish.components.wechat.common.BaseApi;
import cn.zzq0324.radish.components.wechat.constant.OfficialAccountUrls;
import cn.zzq0324.radish.components.wechat.dto.AppInfo;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.token.CodeToAccessTokenRequest;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.token.CodeToAccessTokenResponse;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.token.GetAccessTokenRequest;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.token.GetAccessTokenResponse;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.token.RefreshAccessTokenRequest;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.token.RefreshAccessTokenResponse;

/**
 * 令牌API
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
public class TokenApi extends BaseApi {

  public TokenApi(AppInfo appInfo) {
    super(appInfo);
  }

  /**
   * 获取令牌
   * <p>
   * https://developers.weixin.qq.com/doc/offiaccount/Basic_Information/Get_access_token.html
   */
  public GetAccessTokenResponse getAccessToken() {
    GetAccessTokenRequest request = GetAccessTokenRequest.builder().appId(appInfo.getAppId()).appSecret(
        appInfo.getSecret()).build();

    return execute(OfficialAccountUrls.GET_ACCESS_TOKEN, HttpMethodType.GET, request, GetAccessTokenResponse.class,
        false);
  }

  /**
   * 根据code转换为Token相关信息，详见
   * <p>
   * https://developers.weixin.qq.com/doc/offiaccount/OA_Web_Apps/Wechat_webpage_authorization.html#1
   */
  public CodeToAccessTokenResponse codeToAccessToken(String code) {
    CodeToAccessTokenRequest request = CodeToAccessTokenRequest.builder().code(code).appId(appInfo.getAppId())
        .secret(appInfo.getSecret()).build();

    return execute(OfficialAccountUrls.CODE_TO_TOKEN, HttpMethodType.GET, request, CodeToAccessTokenResponse.class,
        false);
  }

  /**
   * 刷新用户级的access token
   * <p>
   * https://developers.weixin.qq.com/doc/offiaccount/OA_Web_Apps/Wechat_webpage_authorization.html#2
   */
  public RefreshAccessTokenResponse refreshAccessToken(String refreshToken) {
    RefreshAccessTokenRequest request = RefreshAccessTokenRequest.builder().refreshToken(refreshToken).appId(
        appInfo.getAppId()).build();

    return execute(OfficialAccountUrls.REFRESH_TOKEN, HttpMethodType.GET, request, RefreshAccessTokenResponse.class);
  }
}
