package cn.zzq0324.radish.components.wechat.officialaccount.api;

import cn.zzq0324.radish.components.http.constant.HttpMethodType;
import cn.zzq0324.radish.components.wechat.common.BaseApi;
import cn.zzq0324.radish.components.wechat.constant.OfficialAccountUrls;
import cn.zzq0324.radish.components.wechat.dto.AppInfo;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.user.GetUserBasicInfoRequest;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.user.GetUserBasicInfoResponse;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.user.GetUserInfoRequest;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.user.GetUserInfoResponse;

/**
 * 用户相关api
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
public class UserApi extends BaseApi {

  public UserApi(AppInfo appInfo) {
    super(appInfo);
  }

  /**
   * 获取用户基本信息
   * <p>
   * https://developers.weixin.qq.com/doc/offiaccount/User_Management/Get_users_basic_information_UnionID.html#UinonId
   */
  public GetUserBasicInfoResponse getUserBaseInfo(String openId) {
    GetUserBasicInfoRequest request = GetUserBasicInfoRequest.builder().openId(openId).build();

    return execute(OfficialAccountUrls.GET_BASIC_USER_INFO, HttpMethodType.GET, request,
        GetUserBasicInfoResponse.class);
  }

  /**
   * 获取用户信息
   * <p>
   * https://developers.weixin.qq.com/doc/offiaccount/OA_Web_Apps/Wechat_webpage_authorization.html#3
   */
  public GetUserInfoResponse getUserInfo(GetUserInfoRequest request) {
    return execute(OfficialAccountUrls.GET_USER_INFO, HttpMethodType.GET, request, GetUserInfoResponse.class, false);
  }
}
