package cn.zzq0324.radish.components.wechat.officialaccount.dto.calllback;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlCData;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;

/**
 * 回复数据
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Getter
@Setter
@AllArgsConstructor
@JacksonXmlRootElement(localName = "xml")
public class ReplyData {

  /**
   * 加密数据
   */
  @JacksonXmlCData
  @JacksonXmlProperty(localName = "Encrypt")
  private String encrypt;

  /**
   * 签名
   */
  @JacksonXmlCData
  @JacksonXmlProperty(localName = "MsgSignature")
  private String msgSignature;

  /**
   * 时间戳，可以自己生成，也可以用URL参数的timestamp
   */
  @JacksonXmlProperty(localName = "TimeStamp")
  private String timestamp;

  /**
   * 随机字符串
   */
  @JacksonXmlCData
  @JacksonXmlProperty(localName = "Nonce")
  private String nonce;
}
