package cn.zzq0324.radish.components.wechat.officialaccount.dto.event;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlCData;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.Getter;
import lombok.Setter;

/**
 * 点击菜单事件
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Getter
@Setter
@JacksonXmlRootElement(localName = "xml")
public class ClickMenuEvent extends BaseEvent {

  /**
   * 开发者微信号
   */
  @JacksonXmlCData
  @JacksonXmlProperty(localName = "ToUserName")
  private String toUserName;

  /**
   * 发送方帐号（一个OpenID）
   */
  @JacksonXmlCData
  @JacksonXmlProperty(localName = "FromUserName")
  private String fromUserName;

  /**
   * 消息创建时间 （整型）
   */
  @JacksonXmlCData
  @JacksonXmlProperty(localName = "CreateTime")
  private Long createTime;

  /**
   * 事件 KEY 值，与自定义菜单接口中 KEY 值对应
   */
  @JacksonXmlCData
  @JacksonXmlProperty(localName = "EventKey")
  private String eventKey;
}
