package cn.zzq0324.radish.components.wechat.officialaccount.dto.menu;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.Getter;
import lombok.Setter;

/**
 * 菜单按钮
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Getter
@Setter
public class Button {

  public static final String TYPE_VIEW = "view";
  public static final String TYPE_CLICK = "click";
  public static final String TYPE_MINI_PROGRAM = "miniprogram";

  /**
   * 菜单的响应动作类型，view表示网页类型，click表示点击类型，miniprogram表示小程序类型
   */
  @JsonInclude(Include.NON_NULL)
  private String type;

  /**
   * 菜单标题，不超过16个字节，子菜单不超过60个字节
   */
  private String name;

  /**
   * click等点击类型必须	菜单 KEY 值，用于消息接口推送，不超过128字节
   */
  @JsonInclude(Include.NON_NULL)
  private String key;

  /**
   * view、miniprogram类型必须,网页链接用户点击菜单可打开链接，不超1024字节。type为miniprogram时，不支持小程序的老版本客户端将打开本url
   */
  @JsonInclude(Include.NON_NULL)
  private String url;

  /**
   * miniprogram类型必须,小程序的appid（仅认证公众号可配置）
   */
  @JsonInclude(Include.NON_NULL)
  @JsonProperty("appid")
  private String appId;

  /**
   * miniprogram类型必须,小程序的页面路径
   */
  @JsonProperty("pagepath")
  @JsonInclude(Include.NON_NULL)
  private String pagePath;

  /**
   * article_id类型和article_view_limited类型必须，必须是发布后获得的合法 article_id
   */
  @JsonProperty("article_id")
  @JsonInclude(Include.NON_NULL)
  private String articleId;

  @JsonProperty("sub_button")
  @JsonInclude(Include.NON_NULL)
  private List<Button> subButtons;
}
