package cn.zzq0324.radish.components.wechat.officialaccount.dto.message;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlCData;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.Getter;
import lombok.Setter;

/**
 * 回复消息基础类
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Getter
@Setter
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JacksonXmlRootElement(localName = "xml")
public class Message {

  /**
   * 接收方帐号（收到的OpenID）
   */
  @JacksonXmlCData
  @JacksonXmlProperty(localName = "ToUserName")
  private String toUserName;

  /**
   * 开发者微信号
   */
  @JacksonXmlCData
  @JacksonXmlProperty(localName = "FromUserName")
  private String fromUserName;

  /**
   * 消息创建时间 （整型）
   */
  @JacksonXmlCData
  @JacksonXmlProperty(localName = "CreateTime")
  private Long createTime;

  /**
   * 消息ID，回调的时候
   */
  @JacksonXmlCData
  @JacksonXmlProperty(localName = "MsgId")
  private String messageId;

  /**
   * 消息类型，文本为text
   */
  @JacksonXmlCData
  @JacksonXmlProperty(localName = "MsgType")
  private String msgType;

  /**
   * 回复的消息内容（换行：在 content 中能够换行，微信客户端就支持换行显示），文本类型支持
   */
  @JacksonXmlCData
  @JacksonXmlProperty(localName = "Content")
  private String content;
}
