package cn.zzq0324.radish.components.wechat.officialaccount.dto.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

/**
 * 发送模板消息请求参数
 * <p>文档详见：
 * https://developers.weixin.qq.com/doc/offiaccount/Message_Management/Template_Message_Interface.html
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Getter
@Setter
@Builder
public class TemplateMessageRequest {

  /**
   * 接收者OpenId
   */
  @JsonProperty("touser")
  private String receiverOpenId;

  @JsonProperty("template_id")
  private String templateId;

  /**
   * 模板跳转链接,点击模板消息后跳转
   */
  private String url;

  @JsonProperty("miniprogram")
  private MiniProgram miniProgram;

  /**
   * 模板数据
   */
  private String data;

  /**
   * 模板内容字体颜色，不填默认为黑色
   */
  private String color;

  /**
   * 防重入id。对于同一个openid + client_msg_id, 只发送一条消息,10分钟有效,超过10分钟不保证效果。若无防重入需求，可不填
   */
  @JsonProperty("client_msg_id")
  private String clientMessageId;

  /**
   * 跳小程序所需数据，不需跳小程序可不用传该数据
   */
  @Getter
  @Setter
  public static class MiniProgram {

    /**
     * 所需跳转到的小程序appid（该小程序 appid 必须与发模板消息的公众号是绑定关联关系，暂不支持小游戏）
     */
    @JsonProperty("appid")
    private String appId;

    /**
     * 所需跳转到小程序的具体页面路径，支持带参数,（示例index?foo=bar），要求该小程序已发布，暂不支持小游戏
     */
    @JsonProperty("pagepath")
    private String pagePath;
  }
}
