package cn.zzq0324.radish.components.wechat.officialaccount.dto.token;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

/**
 * code转为令牌
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Getter
@Setter
@Builder
public class CodeToAccessTokenRequest {

  /**
   * 公众号的唯一标识
   */
  @JsonProperty("appid")
  private String appId;

  /**
   * 公众号的app secret
   */
  private String secret;

  /**
   * 用户授权后的code
   */
  private String code;

  /**
   *
   */
  @JsonProperty("grant_type")
  private String grantType = "authorization_code";
}
