package cn.zzq0324.radish.components.wechat.officialaccount.dto.token;

import cn.zzq0324.radish.components.wechat.dto.CommonResponse;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 刷新令牌结果
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
public class RefreshAccessTokenResponse extends CommonResponse {

  /**
   * 访问令牌
   */
  @JsonProperty("access_token")
  private String accessToken;

  /**
   * 多少秒之后失效
   */
  @JsonProperty("expires_in")
  private Integer expiresIn;

  /**
   * 刷新令牌
   */
  @JsonProperty("refresh_token")
  private String refreshToken;

  /**
   * 用户唯一标识，请注意，在未关注公众号时，用户访问公众号的网页，也会产生一个用户和公众号唯一的OpenID
   */
  @JsonProperty("openid")
  private String openId;

  /**
   * 用户授权的作用域，使用逗号（,）分隔
   */
  private String scope;
}
