package cn.zzq0324.radish.components.wechat.officialaccount.dto.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

/**
 * 获取用户信息
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Getter
@Setter
@Builder
public class GetUserInfoRequest {

  /**
   * 网页授权接口调用凭证,注意：此access_token与基础支持的access_token不同
   */
  @JsonProperty("access_token")
  private String accessToken;

  /**
   * 用户的唯一标识
   */
  @JsonProperty("openid")
  private String openId;

  /**
   * 返回国家地区语言版本，zh_CN 简体，zh_TW 繁体，en 英语
   */
  @JsonProperty("lang")
  private String lang;
}
