package cn.zzq0324.radish.components.wechat.officialaccount.dto.user;

import cn.zzq0324.radish.components.wechat.dto.CommonResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 获取用户信息
 *
 * @author: zzq0324
 * @since : 1.0.0
 */
@Getter
@Setter
public class GetUserInfoResponse extends CommonResponse {

  /**
   * 用户的标识，对当前公众号唯一
   */
  @JsonProperty("openid")
  private String openId;

  /**
   * 用户昵称
   */
  @JsonProperty("nickname")
  private String nickName;

  /**
   * 用户的性别，值为1时是男性，值为2时是女性，值为0时是未知
   */
  private int sex;

  /**
   * 用户个人资料填写的省份
   */
  private String province;

  /**
   * 普通用户个人资料填写的城市
   */
  private String city;

  /**
   * 国家，如中国为CN
   */
  private String country;

  /**
   * 用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像），
   * <p>
   * 用户没有头像时该项为空。若用户更换头像，原有头像 URL 将失效。
   */
  @JsonProperty("headimgurl")
  private String headImgUrl;
}

