/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.wechat;

import cn.zzq0324.radish.common.spring.SpringContextHolder;
import cn.zzq0324.radish.components.wechat.common.BaseApi;
import cn.zzq0324.radish.components.wechat.config.WechatAppProperties;
import cn.zzq0324.radish.components.wechat.dto.AppInfo;
import cn.zzq0324.radish.components.wechat.miniprogram.api.UserApi;
import cn.zzq0324.radish.components.wechat.officialaccount.api.MenuApi;
import cn.zzq0324.radish.components.wechat.officialaccount.api.MessageApi;
import cn.zzq0324.radish.components.wechat.officialaccount.api.TokenApi;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.ConcurrentLruCache;

public class WechatApiFactory {
    private static OfficialAccountApi officialAccountApi = new OfficialAccountApi();
    private static MiniProgramApi miniProgramApi = new MiniProgramApi();
    protected static WechatAppProperties wechatAppProperties = (WechatAppProperties)SpringContextHolder.getBean(WechatAppProperties.class);
    protected static ConcurrentLruCache<String, Map<Class, Object>> API_CACHE = new ConcurrentLruCache(1024, appId -> new ConcurrentHashMap());

    public static OfficialAccountApi officialAccount() {
        return officialAccountApi;
    }

    public static MiniProgramApi miniProgram() {
        return miniProgramApi;
    }

    private static <T extends BaseApi> T getInstance(String appId, Class<T> type) {
        Map apiMap = (Map)API_CACHE.get((Object)appId);
        return (T)((BaseApi)apiMap.computeIfAbsent(type, apiType -> BaseApi.newInstance(WechatApiFactory.getAppInfo(appId), apiType)));
    }

    private static AppInfo getAppInfo(String appId) {
        AppInfo appInfo = wechatAppProperties.getApps().get(appId);
        if (appInfo == null) {
            throw new UnsupportedOperationException("appId: " + appId + " not configured.");
        }
        return appInfo;
    }

    public static class MiniProgramApi {
        public static UserApi userApi(String appId) {
            return (UserApi)WechatApiFactory.getInstance(appId, UserApi.class);
        }
    }

    public static class OfficialAccountApi {
        public TokenApi tokenApi(String appId) {
            return (TokenApi)WechatApiFactory.getInstance(appId, TokenApi.class);
        }

        public cn.zzq0324.radish.components.wechat.officialaccount.api.UserApi userApi(String appId) {
            return (cn.zzq0324.radish.components.wechat.officialaccount.api.UserApi)WechatApiFactory.getInstance(appId, cn.zzq0324.radish.components.wechat.officialaccount.api.UserApi.class);
        }

        public MenuApi menuApi(String appId) {
            return (MenuApi)WechatApiFactory.getInstance(appId, MenuApi.class);
        }

        public MessageApi messageApi(String appId) {
            return (MessageApi)WechatApiFactory.getInstance(appId, MessageApi.class);
        }
    }
}

