/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.wechat.common;

import cn.zzq0324.radish.components.wechat.common.AccessTokenGenerator;
import cn.zzq0324.radish.components.wechat.dto.AccessToken;
import cn.zzq0324.radish.components.wechat.dto.AppInfo;
import java.util.concurrent.TimeUnit;
import org.springframework.util.ConcurrentLruCache;

public class AccessTokenHolder {
    private static ConcurrentLruCache<AppInfo, AccessToken> TOKEN_CACHE = new ConcurrentLruCache(1024, appInfo -> AccessTokenGenerator.generate(appInfo));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessToken get(AppInfo appInfo) {
        AccessToken accessToken = (AccessToken)TOKEN_CACHE.get((Object)appInfo);
        if (accessToken != null && AccessTokenHolder.isAccessTokenExpired(appInfo, accessToken)) {
            AppInfo appInfo2 = appInfo;
            synchronized (appInfo2) {
                accessToken = (AccessToken)TOKEN_CACHE.get((Object)appInfo);
                if (AccessTokenHolder.isAccessTokenExpired(appInfo, accessToken)) {
                    TOKEN_CACHE.remove((Object)appInfo);
                    accessToken = (AccessToken)TOKEN_CACHE.get((Object)appInfo);
                }
            }
        }
        return accessToken;
    }

    private static boolean isAccessTokenExpired(AppInfo appInfo, AccessToken accessToken) {
        long expireMills = accessToken.getGenerateTime().getTime() + TimeUnit.SECONDS.toMillis(appInfo.getTimeToLive().intValue());
        return expireMills <= System.currentTimeMillis();
    }
}

