/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.wechat.common;

import cn.zzq0324.radish.common.code.CommonStatusCode;
import cn.zzq0324.radish.common.exception.BusinessException;
import cn.zzq0324.radish.common.exception.InternalErrorException;
import cn.zzq0324.radish.common.spring.SpringContextHolder;
import cn.zzq0324.radish.common.util.JsonUtils;
import cn.zzq0324.radish.components.http.RadishHttpClient;
import cn.zzq0324.radish.components.http.constant.HttpMethodType;
import cn.zzq0324.radish.components.http.util.RequestUtils;
import cn.zzq0324.radish.components.wechat.common.AccessTokenHolder;
import cn.zzq0324.radish.components.wechat.dto.AppInfo;
import cn.zzq0324.radish.components.wechat.dto.CommonResponse;
import okhttp3.HttpUrl;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BaseApi {
    private static final Logger log = LoggerFactory.getLogger(BaseApi.class);
    private static final String PARAMETER_ACCESS_TOKEN = "access_token";
    private static final String SUCCESS_CODE = "0";
    private static RadishHttpClient radishHttpClient = (RadishHttpClient)SpringContextHolder.getBean(RadishHttpClient.class);
    protected AppInfo appInfo;

    public BaseApi(AppInfo appInfo) {
        this.appInfo = appInfo;
    }

    protected <T extends CommonResponse> T execute(String url, HttpMethodType methodType, Object requestData, Class<T> responseType) {
        return this.execute(url, methodType, requestData, responseType, true);
    }

    protected <T extends CommonResponse> T execute(String url, HttpMethodType methodType, Object requestData, Class<T> responseType, boolean appendAccessToken) {
        CommonResponse response;
        Request request = RequestUtils.buildRequest((String)url, (HttpMethodType)methodType, (Object)requestData);
        if (appendAccessToken) {
            String accessToken = AccessTokenHolder.get(this.appInfo).getToken();
            HttpUrl httpUrl = request.url().newBuilder().addQueryParameter(PARAMETER_ACCESS_TOKEN, accessToken).build();
            request = request.newBuilder().url(httpUrl).build();
        }
        if (!StringUtils.hasLength((String)(response = (CommonResponse)radishHttpClient.call(request, responseType)).getCode()) || SUCCESS_CODE.equals(response.getCode())) {
            return (T)response;
        }
        log.error("invoke wechat api error, requestUrl: {}, requestData: {}, response: {}", new Object[]{request.url().url(), RequestUtils.getBodyAsString((Request)request), JsonUtils.toJson((Object)response)});
        throw new BusinessException(CommonStatusCode.THIRD_ERROR.args(new Object[]{"invoke wechat error: " + response.getMessage()}));
    }

    public static <T extends BaseApi> T newInstance(AppInfo appInfo, Class<T> type) {
        try {
            return (T)((BaseApi)type.getDeclaredConstructor(AppInfo.class).newInstance(appInfo));
        }
        catch (Exception e) {
            throw new InternalErrorException("new api: " + type.getName() + " instance error", (Throwable)e);
        }
    }
}

