/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.wechat.config;

import cn.zzq0324.radish.components.wechat.dto.AppInfo;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;

@Configuration
@ConditionalOnProperty(value={"radish.wechat.enable"}, havingValue="true")
@ConfigurationProperties(prefix="radish.wechat")
public class WechatAppProperties {
    private Integer accessTokenTimeToLive = 270;
    private Map<String, AppInfo> apps;

    @PostConstruct
    public void initApps() {
        if (CollectionUtils.isEmpty(this.apps)) {
            return;
        }
        this.apps.keySet().forEach(appId -> {
            AppInfo appInfo = this.apps.get(appId);
            appInfo.setAppId((String)appId);
            appInfo.setTimeToLive(this.accessTokenTimeToLive);
        });
    }

    public Integer getAccessTokenTimeToLive() {
        return this.accessTokenTimeToLive;
    }

    public Map<String, AppInfo> getApps() {
        return this.apps;
    }

    public void setAccessTokenTimeToLive(Integer accessTokenTimeToLive) {
        this.accessTokenTimeToLive = accessTokenTimeToLive;
    }

    public void setApps(Map<String, AppInfo> apps) {
        this.apps = apps;
    }
}

