/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.wechat.controller;

import cn.zzq0324.radish.common.util.JsonUtils;
import cn.zzq0324.radish.common.util.XmlUtils;
import cn.zzq0324.radish.components.wechat.config.WechatAppProperties;
import cn.zzq0324.radish.components.wechat.crypto.MessageCrypto;
import cn.zzq0324.radish.components.wechat.dto.AppInfo;
import cn.zzq0324.radish.components.wechat.handler.WechatCallbackHandler;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.calllback.AesEncryptData;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.calllback.DecryptedData;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.calllback.EventCallbackRequest;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.calllback.VerifyUrlRequest;
import cn.zzq0324.radish.extension.BusinessScenario;
import cn.zzq0324.radish.extension.ExtensionLoader;
import cn.zzq0324.radish.web.annotation.SkipInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.ResolvableType;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@SkipInterceptor
@RestController
@RequestMapping(value={"/api/wechat/callback"})
@ConditionalOnProperty(value={"radish.wechat.enable"}, havingValue="true")
public class WechatCallbackController {
    private static final Logger log = LoggerFactory.getLogger(WechatCallbackController.class);
    @Autowired
    private WechatAppProperties appProperties;

    @GetMapping(value={"/{appId}"})
    public String verifyUrl(@PathVariable(value="appId") String appId, VerifyUrlRequest request) {
        log.info("appId: {} receive verify url request, request data: {}", (Object)appId, (Object)JsonUtils.toJson((Object)request));
        MessageCrypto crypto = this.getMessageCrypto(appId);
        crypto.validateSign(request.getTimestamp(), request.getNonce(), request.getSignature());
        return request.getEchostr();
    }

    @Transactional
    @PostMapping(value={"/{appId}"})
    public Object eventCallback(@PathVariable(value="appId") String appId, @RequestBody String postData, EventCallbackRequest request) {
        MessageCrypto crypto = this.getMessageCrypto(appId);
        crypto.validateSign(request.getTimestamp(), request.getNonce(), request.getSignature());
        if (StringUtils.hasLength((String)request.getEncrypt_type())) {
            postData = ((AesEncryptData)XmlUtils.fromXML((String)postData, AesEncryptData.class)).getEncrypt();
        }
        String data = crypto.decrypt(request.getTimestamp(), request.getNonce(), request.getMsg_signature(), postData);
        log.info("appId: {} receive callback from wechat, callback data: {}", (Object)appId, (Object)data);
        String replyMsg = this.handleCallback(appId, data);
        if (StringUtils.hasLength((String)replyMsg)) {
            replyMsg = crypto.encrypt(replyMsg, request.getTimestamp(), request.getNonce());
        }
        return replyMsg;
    }

    private String handleCallback(String appId, String data) {
        BusinessScenario radishScenario = BusinessScenario.of((String)"radish");
        this.executeEventHandler(appId, radishScenario, true, data);
        DecryptedData decryptedData = (DecryptedData)XmlUtils.fromXML((String)data, DecryptedData.class);
        BusinessScenario bizScenario = decryptedData.getMsgType().equals("event") ? BusinessScenario.of((String)decryptedData.getMsgType(), (String)decryptedData.getEvent(), (String)appId) : BusinessScenario.of((String)decryptedData.getMsgType(), (String)"defaultUseCase", (String)appId);
        return this.executeEventHandler(appId, bizScenario, true, data);
    }

    private String executeEventHandler(String appId, BusinessScenario scenario, boolean failOver, String data) {
        WechatCallbackHandler handler = (WechatCallbackHandler)ExtensionLoader.getExtension(WechatCallbackHandler.class, (BusinessScenario)scenario, (boolean)failOver);
        if (handler == null) {
            return "";
        }
        ResolvableType resolvableType = ResolvableType.forClass(handler.getClass()).as(WechatCallbackHandler.class);
        Object result = handler.handle(appId, XmlUtils.fromXML((String)data, (Class)resolvableType.getGeneric(new int[]{0}).resolve()));
        if (result == null) {
            return "";
        }
        return XmlUtils.toXML(result);
    }

    private MessageCrypto getMessageCrypto(String appId) {
        AppInfo appInfo = this.appProperties.getApps().get(appId);
        return new MessageCrypto(appInfo.getToken(), appInfo.getEncodingAesKey(), appId);
    }
}

