/*
 * Decompiled with CFR 0.152.
 */
package cn.zzq0324.radish.components.wechat.crypto;

import cn.zzq0324.radish.common.util.MessageDigestUtils;
import cn.zzq0324.radish.common.util.XmlUtils;
import cn.zzq0324.radish.components.wechat.crypto.ByteGroup;
import cn.zzq0324.radish.components.wechat.crypto.PKCS7Encoder;
import cn.zzq0324.radish.components.wechat.officialaccount.dto.calllback.ReplyData;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;

public class MessageCrypto {
    private byte[] aesKey;
    private String token;
    private String appId;

    public MessageCrypto(String token, String encodingAesKey, String appId) {
        Assert.isTrue((encodingAesKey.length() == 43 ? 1 : 0) != 0, (String)"illegal encodingAesKey, length must be 43!");
        this.token = token;
        this.appId = appId;
        this.aesKey = Base64Utils.decodeFromString((String)(encodingAesKey + "="));
    }

    public String decrypt(String timestamp, String nonce, String msgSignature, String postData) {
        String signature = MessageDigestUtils.getSHA1((String)MessageCrypto.getSha1Data(this.token, timestamp, nonce, postData));
        if (!signature.equals(msgSignature)) {
            throw new RuntimeException("msgSignature not match!");
        }
        return this.decrypt(postData);
    }

    public String encrypt(String replyMsg, String timestamp, String nonce) {
        String encrypt = this.encrypt(this.getRandomStr(), replyMsg);
        String signature = MessageDigestUtils.getSHA1((String)MessageCrypto.getSha1Data(this.token, timestamp, nonce, encrypt));
        ReplyData replyData = new ReplyData(encrypt, signature, timestamp, nonce);
        return XmlUtils.toXML((Object)replyData);
    }

    private byte[] getNetworkBytesOrder(int sourceNumber) {
        byte[] orderBytes = new byte[4];
        orderBytes[3] = (byte)(sourceNumber & 0xFF);
        orderBytes[2] = (byte)(sourceNumber >> 8 & 0xFF);
        orderBytes[1] = (byte)(sourceNumber >> 16 & 0xFF);
        orderBytes[0] = (byte)(sourceNumber >> 24 & 0xFF);
        return orderBytes;
    }

    private int recoverNetworkBytesOrder(byte[] orderBytes) {
        int sourceNumber = 0;
        for (int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= orderBytes[i] & 0xFF;
        }
        return sourceNumber;
    }

    private String getRandomStr() {
        String base = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    private String encrypt(String randomStr, String text) {
        ByteGroup byteCollector = new ByteGroup();
        byte[] randomStrBytes = randomStr.getBytes(StandardCharsets.UTF_8);
        byte[] textBytes = text.getBytes(StandardCharsets.UTF_8);
        byte[] networkBytesOrder = this.getNetworkBytesOrder(textBytes.length);
        byte[] appIdBytes = this.appId.getBytes(StandardCharsets.UTF_8);
        byteCollector.addBytes(randomStrBytes);
        byteCollector.addBytes(networkBytesOrder);
        byteCollector.addBytes(textBytes);
        byteCollector.addBytes(appIdBytes);
        byte[] padBytes = PKCS7Encoder.encode(byteCollector.size());
        byteCollector.addBytes(padBytes);
        byte[] unencrypted = byteCollector.toBytes();
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.aesKey, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            byte[] encrypted = cipher.doFinal(unencrypted);
            String base64Encrypted = Base64Utils.encodeToString((byte[])encrypted);
            return base64Encrypted;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String decrypt(String text) {
        byte[] original;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec key_spec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(this.aesKey, 0, 16));
            cipher.init(2, (Key)key_spec, iv);
            byte[] encrypted = Base64Utils.decodeFromString((String)text);
            original = cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] bytes = PKCS7Encoder.decode(original);
        byte[] networkOrder = Arrays.copyOfRange(bytes, 16, 20);
        int xmlLength = this.recoverNetworkBytesOrder(networkOrder);
        String messageContent = new String(Arrays.copyOfRange(bytes, 20, 20 + xmlLength), StandardCharsets.UTF_8);
        String fromAppId = new String(Arrays.copyOfRange(bytes, 20 + xmlLength, bytes.length), StandardCharsets.UTF_8);
        if (!fromAppId.equals(this.appId)) {
            throw new RuntimeException("AppId not match");
        }
        return messageContent;
    }

    public void validateSign(String timestamp, String nonce, String signature) {
        String calculateSign = MessageDigestUtils.getSHA1((String)MessageCrypto.getSha1Data(this.token, timestamp, nonce));
        if (!calculateSign.equals(signature)) {
            throw new RuntimeException("signature not match!");
        }
    }

    private static String getSha1Data(String ... data) {
        StringBuffer stringBuffer = new StringBuffer();
        Arrays.sort(data);
        for (int i = 0; i < data.length; ++i) {
            stringBuffer.append(data[i]);
        }
        return stringBuffer.toString();
    }
}

