/*
 * Decompiled with CFR 0.152.
 */
package cn.shorturl.core;

import cn.shorturl.core.ShortUrlConfig;
import cn.shorturl.core.enums.HashType;
import cn.shorturl.core.util.Base62;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;

public class ShortUrlUtil {
    private ShortUrlConfig config;
    private final HashFunction hashFunction;
    private static final Base62 base62 = Base62.createInstance();

    public ShortUrlUtil() {
        this.config = new ShortUrlConfig();
        this.hashFunction = ShortUrlUtil.getHashFunction(this.config);
    }

    public ShortUrlUtil(ShortUrlConfig config) {
        this.config = config;
        this.hashFunction = ShortUrlUtil.getHashFunction(config);
    }

    public String gen(String url) {
        HashCode hashCode = this.hashFunction.hashString((CharSequence)url, StandardCharsets.UTF_8);
        byte[] bytes = hashCode.asBytes();
        return new String(base62.encode(bytes));
    }

    private static HashFunction getHashFunction(ShortUrlConfig config) {
        return ShortUrlUtil.getHashFunction(config.getHashType(), config.getHashKey());
    }

    private static HashFunction getHashFunction(HashType type, String key) {
        if (type == null) {
            return Hashing.murmur3_32_fixed();
        }
        if (key == null) {
            key = ShortUrlUtil.class.getName();
        }
        byte[] keyBytes = key.getBytes();
        switch (type) {
            case MD5: {
                return Hashing.md5();
            }
            case GOOD_FAST_HASH: {
                return Hashing.goodFastHash((int)32);
            }
            case SHA1: {
                return Hashing.sha1();
            }
            case SHA256: {
                return Hashing.sha256();
            }
            case SHA384: {
                return Hashing.sha384();
            }
            case SHA512: {
                return Hashing.sha512();
            }
            case HMAC_MD5: {
                return Hashing.hmacMd5((byte[])keyBytes);
            }
            case HMAC_SHA1: {
                return Hashing.hmacSha1((byte[])keyBytes);
            }
            case HMAC_SHA256: {
                return Hashing.hmacSha256((byte[])keyBytes);
            }
            case HMAC_SHA512: {
                return Hashing.hmacSha512((byte[])keyBytes);
            }
            case CRC32_C: {
                return Hashing.crc32c();
            }
            case ADLER32: {
                return Hashing.adler32();
            }
            case FARM_HASH_FINGERPRINT64: {
                return Hashing.farmHashFingerprint64();
            }
            case FINGERPRINT2011: {
                return Hashing.fingerprint2011();
            }
            case MURMUR3_32: {
                return Hashing.murmur3_32();
            }
            case MURMUR3_128: {
                return Hashing.murmur3_128();
            }
            case SIP_HASH24: {
                return Hashing.sipHash24();
            }
        }
        return Hashing.murmur3_32_fixed();
    }

    public ShortUrlConfig getConfig() {
        return this.config;
    }

    public HashFunction getHashFunction() {
        return this.hashFunction;
    }

    public ShortUrlUtil setConfig(ShortUrlConfig config) {
        this.config = config;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShortUrlUtil)) {
            return false;
        }
        ShortUrlUtil other = (ShortUrlUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ShortUrlConfig this$config = this.getConfig();
        ShortUrlConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        HashFunction this$hashFunction = this.getHashFunction();
        HashFunction other$hashFunction = other.getHashFunction();
        return !(this$hashFunction == null ? other$hashFunction != null : !this$hashFunction.equals(other$hashFunction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShortUrlUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ShortUrlConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        HashFunction $hashFunction = this.getHashFunction();
        result = result * 59 + ($hashFunction == null ? 43 : $hashFunction.hashCode());
        return result;
    }

    public String toString() {
        return "ShortUrlUtil(config=" + this.getConfig() + ", hashFunction=" + this.getHashFunction() + ")";
    }
}

