/*
 * Decompiled with CFR 0.152.
 */
package com._4paradigm.hybridse.sdk;

import com._4paradigm.hybridse.HybridSeLibrary;
import com._4paradigm.hybridse.vm.Engine;
import com._4paradigm.hybridse.vm.HybridSeJitWrapper;
import com._4paradigm.hybridse.vm.JitOptions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JitManager {
    private static Logger logger = LoggerFactory.getLogger(JitManager.class);
    private static Map<String, HybridSeJitWrapper> jits = new HashMap<String, HybridSeJitWrapper>();
    private static Set<String> initializedModuleTags = new HashSet<String>();

    public static synchronized HybridSeJitWrapper getJit(String tag) {
        if (!jits.containsKey(tag)) {
            HybridSeJitWrapper jit = HybridSeJitWrapper.Create((JitOptions)JitManager.getJitOptions());
            if (jit == null) {
                throw new RuntimeException("Fail to create native jit");
            }
            jit.Init();
            HybridSeJitWrapper.InitJitSymbols((HybridSeJitWrapper)jit);
            jits.put(tag, jit);
        }
        return jits.get(tag);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JitOptions getJitOptions() {
        JitOptions options = new JitOptions();
        try (InputStream input = JitManager.class.getClassLoader().getResourceAsStream("jit.properties");){
            String enableGdb;
            String enablePerf;
            String enableVtune;
            Properties prop = new Properties(System.getProperties());
            if (input == null) {
                JitOptions jitOptions = options;
                return jitOptions;
            }
            prop.load(input);
            String enableMcJit = prop.getProperty("fesql.jit.enable_mcjit");
            if (enableMcJit != null && enableMcJit.toLowerCase().equals("true")) {
                logger.info("Try enable llvm legacy mcjit support");
                options.set_enable_mcjit(true);
            }
            if ((enableVtune = prop.getProperty("fesql.jit.enable_vtune")) != null && enableVtune.toLowerCase().equals("true")) {
                logger.info("Try enable intel jit events support");
                options.set_enable_vtune(true);
            }
            if ((enablePerf = prop.getProperty("fesql.jit.enable_perf")) != null && enablePerf.toLowerCase().equals("true")) {
                logger.info("Try enable perf jit events support");
                options.set_enable_perf(true);
            }
            if ((enableGdb = prop.getProperty("fesql.jit.enable_gdb")) == null) return options;
            if (!enableGdb.toLowerCase().equals("true")) return options;
            logger.info("Try enable gdb jit events support");
            options.set_enable_gdb(true);
            return options;
        }
        catch (IOException ex) {
            logger.debug("Can not find jit.properties", (Throwable)ex);
        }
        return options;
    }

    private static synchronized boolean hasModule(String tag) {
        return initializedModuleTags.contains(tag);
    }

    private static synchronized void initModule(String tag, ByteBuffer moduleBuffer) {
        HybridSeJitWrapper jit = JitManager.getJit(tag);
        if (!moduleBuffer.isDirect()) {
            throw new RuntimeException("JIT must use direct buffer");
        }
        if (!jit.AddModuleFromBuffer(moduleBuffer)) {
            throw new RuntimeException("Fail to initialize native module");
        }
        initializedModuleTags.add(tag);
    }

    public static synchronized void initCore() {
        HybridSeLibrary.initCore();
        Engine.InitializeGlobalLLVM();
    }

    public static synchronized void initCore(String jsdkCoreLibraryPath) {
        HybridSeLibrary.initCore(jsdkCoreLibraryPath);
        Engine.InitializeGlobalLLVM();
    }

    public static synchronized void initJitModule(String tag, ByteBuffer moduleBuffer) {
        HybridSeLibrary.initCore();
        if (!JitManager.hasModule(tag)) {
            JitManager.initModule(tag, moduleBuffer);
        }
    }

    public static synchronized void initJitModule(String tag, ByteBuffer moduleBuffer, String jsdkCoreLibraryPath) {
        HybridSeLibrary.initCore(jsdkCoreLibraryPath);
        if (!JitManager.hasModule(tag)) {
            JitManager.initModule(tag, moduleBuffer);
            logger.info("Init jit module with tag:\n" + tag);
        }
    }

    public static synchronized void removeModule(String tag) {
        initializedModuleTags.remove(tag);
        HybridSeJitWrapper jit = jits.remove(tag);
        if (jit != null) {
            HybridSeJitWrapper.DeleteJit((HybridSeJitWrapper)jit);
            jit.delete();
        }
    }

    public static synchronized void clear() {
        initializedModuleTags.clear();
        for (Map.Entry<String, HybridSeJitWrapper> entry : jits.entrySet()) {
            HybridSeJitWrapper.DeleteJit((HybridSeJitWrapper)entry.getValue());
            entry.getValue().delete();
        }
        jits.clear();
    }
}

