/*
 * Decompiled with CFR 0.152.
 */
package com._4paradigm.hybridse.sdk;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class SerializableByteBuffer
implements Serializable {
    private transient ByteBuffer buffer;
    private static final int MAGIC_END_TAG = 42;

    public SerializableByteBuffer() {
    }

    public SerializableByteBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.buffer == null) {
            throw new IOException("No backed buffer");
        }
        out.defaultWriteObject();
        out.writeInt(this.buffer.capacity());
        out.writeBoolean(this.buffer.isDirect());
        if (this.buffer.hasArray()) {
            out.write(this.buffer.array(), 0, this.buffer.capacity());
        } else {
            byte[] bytes = new byte[this.buffer.capacity()];
            ByteBuffer view = this.buffer.duplicate();
            view.rewind();
            view.get(bytes, 0, bytes.length);
            out.write(bytes);
        }
        out.writeInt(42);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int endTag;
        in.defaultReadObject();
        DataInputStream wrappedInStream = new DataInputStream(in);
        int capacity = wrappedInStream.readInt();
        boolean isDirect = wrappedInStream.readBoolean();
        this.buffer = isDirect ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        byte[] bytes = this.buffer.hasArray() ? this.buffer.array() : new byte[capacity];
        try {
            wrappedInStream.readFully(bytes, 0, capacity);
        }
        catch (IOException e) {
            throw new IOException("Byte buffer stream corrupt, expect buffer bytes: " + capacity, e);
        }
        if (!this.buffer.hasArray()) {
            this.buffer.put(bytes, 0, capacity);
            this.buffer.rewind();
        }
        if ((endTag = wrappedInStream.readInt()) != 42) {
            throw new IOException("Byte buffer stream corrupt");
        }
    }
}

