/*
 * Decompiled with CFR 0.152.
 */
package com._4paradigm.hybridse.sdk;

import com._4paradigm.hybridse.base.BaseStatus;
import com._4paradigm.hybridse.sdk.UnsupportedHybridSeException;
import com._4paradigm.hybridse.type.TypeOuterClass;
import com._4paradigm.hybridse.vm.BatchRunSession;
import com._4paradigm.hybridse.vm.Catalog;
import com._4paradigm.hybridse.vm.CompileInfo;
import com._4paradigm.hybridse.vm.Engine;
import com._4paradigm.hybridse.vm.EngineOptions;
import com._4paradigm.hybridse.vm.PhysicalOpNode;
import com._4paradigm.hybridse.vm.RunSession;
import com._4paradigm.hybridse.vm.SimpleCatalog;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlEngine
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(SqlEngine.class);
    private SimpleCatalog catalog;
    private EngineOptions options;
    private Engine engine;
    private BatchRunSession session;
    private CompileInfo compileInfo;
    private PhysicalOpNode plan;

    public SqlEngine(String sql, TypeOuterClass.Database database) throws UnsupportedHybridSeException {
        this.initilize(sql, database, SqlEngine.createDefaultEngineOptions());
    }

    public SqlEngine(String sql, TypeOuterClass.Database database, EngineOptions engineOptions) throws UnsupportedHybridSeException {
        this.initilize(sql, database, engineOptions);
    }

    public static EngineOptions createDefaultEngineOptions() {
        EngineOptions engineOptions = new EngineOptions();
        engineOptions.set_keep_ir(true);
        engineOptions.set_compile_only(true);
        engineOptions.set_performance_sensitive(false);
        return engineOptions;
    }

    public void initilize(String sql, TypeOuterClass.Database database, EngineOptions engineOptions) throws UnsupportedHybridSeException {
        this.options = engineOptions;
        this.catalog = new SimpleCatalog();
        this.session = new BatchRunSession();
        this.catalog.AddDatabase(database);
        this.engine = new Engine((Catalog)this.catalog, this.options);
        BaseStatus status = new BaseStatus();
        boolean ok = this.engine.Get(sql, database.getName(), (RunSession)this.session, status);
        if (!ok || !status.getMsg().equals("ok")) {
            throw new UnsupportedHybridSeException("SQL parse error: " + status.getMsg() + "\n" + status.getTrace());
        }
        status.delete();
        this.compileInfo = this.session.GetCompileInfo();
        this.plan = this.compileInfo.GetPhysicalPlan();
    }

    public PhysicalOpNode getPlan() {
        return this.plan;
    }

    public ByteBuffer getIrBuffer() {
        long size = this.compileInfo.GetIRSize();
        ByteBuffer buffer = ByteBuffer.allocateDirect(Long.valueOf(size).intValue());
        this.compileInfo.GetIRBuffer(buffer);
        logger.info("Dumped module size: {}", (Object)size);
        return buffer;
    }

    @Override
    public synchronized void close() throws Exception {
        this.engine.delete();
        this.engine = null;
        this.compileInfo.delete();
        this.compileInfo = null;
        this.options.delete();
        this.options = null;
        this.plan.delete();
        this.plan = null;
        this.session.delete();
        this.session = null;
        this.catalog.delete();
        this.catalog = null;
    }
}

