/*
 * Decompiled with CFR 0.152.
 */
package com._4paradigm.hybridse;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryLoader {
    private static final Logger logger = LoggerFactory.getLogger((String)LibraryLoader.class.getName());

    public static synchronized void loadLibrary(String libraryPath) {
        boolean isPath;
        logger.info("Try to load the library {}", (Object)libraryPath);
        boolean bl = isPath = libraryPath.endsWith(".so") || libraryPath.endsWith(".dylib");
        if (!isPath) {
            try {
                System.loadLibrary(libraryPath);
                logger.info("Successfully load library {}", (Object)libraryPath);
                return;
            }
            catch (Throwable t) {
                logger.debug(String.format("Failed to load %s", libraryPath), t);
            }
        }
        if (!isPath) {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.equals("mac os x")) {
                libraryPath = "lib" + libraryPath + ".dylib";
            } else if (osName.contains("linux")) {
                libraryPath = "lib" + libraryPath + ".so";
            } else {
                throw new IllegalArgumentException("Do not support os type: " + osName);
            }
        }
        try {
            System.load(libraryPath);
            logger.info("Successfully load library from {}", (Object)libraryPath);
            return;
        }
        catch (Throwable t) {
            block15: {
                logger.debug(String.format("Failed to load from %s", libraryPath), t);
                logger.info("Can not find {} from environment, try find in resources", (Object)libraryPath);
                try {
                    URL resource = LibraryLoader.class.getClassLoader().getResource(libraryPath);
                    if (resource != null) {
                        try {
                            System.load(resource.getPath());
                        }
                        catch (UnsatisfiedLinkError e) {
                            String localPath = LibraryLoader.extractResource(libraryPath, true);
                            logger.info("Extract resource to {}", (Object)localPath);
                            System.load(localPath);
                        }
                        logger.info("Successfully load {} in local resource", (Object)resource.getPath());
                        break block15;
                    }
                    logger.error(String.format("Fail to find %s in resources", libraryPath));
                }
                catch (IOException | UnsatisfiedLinkError e) {
                    logger.error(String.format("Error while load %s from local resource", libraryPath), e);
                    e.printStackTrace();
                    throw new UnsatisfiedLinkError(String.format("Fail to load library %s", libraryPath));
                }
            }
            return;
        }
    }

    public static String extractResource(String path, boolean isTemp) throws IOException {
        InputStream inputStream = LibraryLoader.class.getClassLoader().getResourceAsStream(path);
        if (inputStream != null) {
            File localFile;
            logger.info("Found {} in local resource", (Object)path);
            if (isTemp) {
                String suffix = path.replace("/", "-");
                localFile = File.createTempFile("temp-", suffix);
            } else {
                File parent;
                localFile = new File("./", path);
                if (localFile.exists()) {
                    logger.warn("Existing path {}, will overwrite", (Object)localFile.getPath());
                }
                if ((parent = localFile.getParentFile()) != null && !parent.exists()) {
                    parent.mkdirs();
                }
            }
            localFile.deleteOnExit();
            String absolutePath = localFile.getAbsolutePath();
            try (FileOutputStream outputStream = new FileOutputStream(absolutePath);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                String string = absolutePath;
                return string;
            }
        }
        throw new IOException(String.format("Can not find %s in local resource", path));
    }
}

