/*
 * Decompiled with CFR 0.152.
 */
package com._4paradigm.hybridse.sdk;

import com._4paradigm.hybridse.base.BaseStatus;
import com._4paradigm.hybridse.sdk.SqlEngine;
import com._4paradigm.hybridse.sdk.UnsupportedHybridSeException;
import com._4paradigm.hybridse.type.TypeOuterClass;
import com._4paradigm.hybridse.vm.Catalog;
import com._4paradigm.hybridse.vm.CompileInfo;
import com._4paradigm.hybridse.vm.Engine;
import com._4paradigm.hybridse.vm.EngineOptions;
import com._4paradigm.hybridse.vm.PhysicalOpNode;
import com._4paradigm.hybridse.vm.RequestRunSession;
import com._4paradigm.hybridse.vm.RunSession;
import com._4paradigm.hybridse.vm.SimpleCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestEngine
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(SqlEngine.class);
    private SimpleCatalog catalog;
    private EngineOptions options = new EngineOptions();
    private Engine engine;
    private RequestRunSession session;
    private CompileInfo compileInfo;
    private PhysicalOpNode plan;

    public RequestEngine(String sql, TypeOuterClass.Database database) throws UnsupportedHybridSeException {
        this.options.SetKeepIr(true);
        this.options.SetCompileOnly(true);
        this.catalog = new SimpleCatalog();
        this.session = new RequestRunSession();
        this.session.SetPerformanceSensitive(false);
        this.catalog.AddDatabase(database);
        this.engine = new Engine((Catalog)this.catalog, this.options);
        BaseStatus status = new BaseStatus();
        boolean ok = this.engine.Get(sql, database.getName(), (RunSession)this.session, status);
        if (!ok || !status.getMsg().equals("ok")) {
            throw new UnsupportedHybridSeException("SQL parse error: " + status.getMsg());
        }
        status.delete();
        this.compileInfo = this.session.GetCompileInfo();
        this.plan = this.compileInfo.GetPhysicalPlan();
    }

    public PhysicalOpNode getPlan() {
        return this.plan;
    }

    @Override
    public synchronized void close() {
        this.engine.delete();
        this.engine = null;
        this.compileInfo.delete();
        this.compileInfo = null;
        this.options.delete();
        this.options = null;
        this.plan.delete();
        this.plan = null;
        this.session.delete();
        this.session = null;
        this.catalog.delete();
        this.catalog = null;
    }
}

