/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection;

import fiftyone.devicedetection.cloud.flowelements.DeviceDetectionCloudEngineBuilder;
import fiftyone.pipeline.cloudrequestengine.flowelements.CloudRequestEngine;
import fiftyone.pipeline.cloudrequestengine.flowelements.CloudRequestEngineBuilder;
import fiftyone.pipeline.core.flowelements.Pipeline;
import fiftyone.pipeline.engines.configuration.CacheConfiguration;
import fiftyone.pipeline.engines.configuration.LazyLoadingConfiguration;
import fiftyone.pipeline.engines.flowelements.CloudPipelineBuilderBase;
import fiftyone.pipeline.engines.services.HttpClient;
import org.slf4j.ILoggerFactory;

public class DeviceDetectionCloudPipelineBuilder
extends CloudPipelineBuilderBase<DeviceDetectionCloudPipelineBuilder> {
    private final HttpClient httpClient;

    public DeviceDetectionCloudPipelineBuilder(ILoggerFactory loggerFactory, HttpClient httpClient) {
        super(loggerFactory);
        this.httpClient = httpClient;
    }

    public Pipeline build() throws Exception {
        CloudRequestEngineBuilder cloudRequestEngineBuilder = new CloudRequestEngineBuilder(this.loggerFactory, this.httpClient);
        if (this.lazyLoading) {
            cloudRequestEngineBuilder.setLazyLoading(new LazyLoadingConfiguration((int)this.lazyLoadingTimeoutMillis));
        }
        if (this.resultsCache) {
            cloudRequestEngineBuilder.setCache(new CacheConfiguration(this.resultsCacheSize));
        }
        if (this.url != null && !this.url.isEmpty()) {
            cloudRequestEngineBuilder.setEndpoint(this.url);
        }
        if (this.dataEndpoint != null && !this.dataEndpoint.isEmpty()) {
            cloudRequestEngineBuilder.setDataEndpoint(this.dataEndpoint);
        }
        if (this.propertiesEndpoint != null && !this.propertiesEndpoint.isEmpty()) {
            cloudRequestEngineBuilder.setPropertiesEndpoint(this.propertiesEndpoint);
        }
        if (this.evidenceKeysEndpoint != null && !this.evidenceKeysEndpoint.isEmpty()) {
            cloudRequestEngineBuilder.setEvidenceKeysEndpoint(this.evidenceKeysEndpoint);
        }
        if (this.resourceKey != null && !this.resourceKey.isEmpty()) {
            cloudRequestEngineBuilder.setResourceKey(this.resourceKey);
        }
        if (this.licenseKey != null && !this.licenseKey.isEmpty()) {
            cloudRequestEngineBuilder.setLicenseKey(this.licenseKey);
        }
        if (this.cloudRequestOrigin != null && !this.cloudRequestOrigin.isEmpty()) {
            cloudRequestEngineBuilder.setCloudRequestOrigin(this.cloudRequestOrigin);
        }
        CloudRequestEngine cloudRequestEngine = cloudRequestEngineBuilder.build();
        DeviceDetectionCloudEngineBuilder deviceDetectionEngineBuilder = new DeviceDetectionCloudEngineBuilder(this.loggerFactory);
        if (this.lazyLoading) {
            deviceDetectionEngineBuilder.setLazyLoading(new LazyLoadingConfiguration((int)this.lazyLoadingTimeoutMillis));
        }
        this.flowElements.add(cloudRequestEngine);
        this.flowElements.add(deviceDetectionEngineBuilder.build());
        return super.build();
    }
}

