/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.devicedetection;

import fiftyone.devicedetection.DeviceDetectionCloudPipelineBuilder;
import fiftyone.devicedetection.DeviceDetectionOnPremisePipelineBuilder;
import fiftyone.devicedetection.Enums;
import fiftyone.pipeline.engines.services.DataUpdateService;
import fiftyone.pipeline.engines.services.DataUpdateServiceDefault;
import fiftyone.pipeline.engines.services.HttpClient;
import fiftyone.pipeline.engines.services.HttpClientDefault;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class DeviceDetectionPipelineBuilder {
    protected final ILoggerFactory loggerFactory;
    private final DataUpdateService dataUpdateService;
    private final HttpClient httpClient;

    public DeviceDetectionPipelineBuilder() {
        this(LoggerFactory.getILoggerFactory());
    }

    public DeviceDetectionPipelineBuilder(ILoggerFactory loggerFactory) {
        this(loggerFactory, (HttpClient)new HttpClientDefault());
    }

    public DeviceDetectionPipelineBuilder(ILoggerFactory loggerFactory, HttpClient httpClient) {
        this(loggerFactory, httpClient, (DataUpdateService)new DataUpdateServiceDefault(loggerFactory.getLogger(DataUpdateServiceDefault.class.getName()), httpClient));
    }

    public DeviceDetectionPipelineBuilder(ILoggerFactory loggerFactory, HttpClient httpClient, DataUpdateService dataUpdateService) {
        this.httpClient = httpClient;
        this.loggerFactory = loggerFactory;
        this.dataUpdateService = dataUpdateService;
    }

    public DeviceDetectionOnPremisePipelineBuilder useOnPremise(String datafile, boolean createTempDataCopy) throws Exception {
        DeviceDetectionOnPremisePipelineBuilder builder = new DeviceDetectionOnPremisePipelineBuilder(this.loggerFactory, this.dataUpdateService, this.httpClient);
        builder.setFilename(datafile, createTempDataCopy);
        return builder;
    }

    @Deprecated
    public DeviceDetectionOnPremisePipelineBuilder useOnPremise(byte[] data, Enums.DeviceDetectionAlgorithm algorithm) {
        return this.useOnPremise(data);
    }

    public DeviceDetectionOnPremisePipelineBuilder useOnPremise(byte[] data) {
        DeviceDetectionOnPremisePipelineBuilder builder = new DeviceDetectionOnPremisePipelineBuilder(this.loggerFactory, this.dataUpdateService, this.httpClient);
        builder.setEngineData(data);
        return builder;
    }

    public DeviceDetectionCloudPipelineBuilder useCloud(String resourceKey) {
        DeviceDetectionCloudPipelineBuilder builder = new DeviceDetectionCloudPipelineBuilder(this.loggerFactory, this.httpClient);
        builder.setResourceKey(resourceKey);
        return builder;
    }
}

