/*
 * Decompiled with CFR 0.152.
 */
package com.aallam.ktoken.internal;

import com.aallam.ktoken.Tokenizer;
import com.aallam.ktoken.internal.CoreBPE;
import com.aallam.ktoken.internal.RegexKt;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\f\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0016J2\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0012\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/aallam/ktoken/internal/TokenEncoder;", "Lcom/aallam/ktoken/Tokenizer;", "bpe", "Lcom/aallam/ktoken/internal/CoreBPE;", "specialTokensSet", "", "", "(Lcom/aallam/ktoken/internal/CoreBPE;Ljava/util/Set;)V", "getBpe", "()Lcom/aallam/ktoken/internal/CoreBPE;", "getSpecialTokensSet", "()Ljava/util/Set;", "decode", "token", "", "tokens", "", "encode", "text", "allowedSpecial", "disallowedSpecial", "encodeSingleToken", "ktoken"})
@SourceDebugExtension(value={"SMAP\nTokenEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenEncoder.kt\ncom/aallam/ktoken/internal/TokenEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1#2:46\n*E\n"})
public final class TokenEncoder
implements Tokenizer {
    @NotNull
    private final CoreBPE bpe;
    @NotNull
    private final Set<String> specialTokensSet;

    public TokenEncoder(@NotNull CoreBPE bpe, @NotNull Set<String> specialTokensSet) {
        Intrinsics.checkNotNullParameter((Object)bpe, (String)"bpe");
        Intrinsics.checkNotNullParameter(specialTokensSet, (String)"specialTokensSet");
        this.bpe = bpe;
        this.specialTokensSet = specialTokensSet;
    }

    @NotNull
    public final CoreBPE getBpe() {
        return this.bpe;
    }

    @NotNull
    public final Set<String> getSpecialTokensSet() {
        return this.specialTokensSet;
    }

    @Override
    @NotNull
    public List<Integer> encode(@NotNull String text, @NotNull Set<String> allowedSpecial, @NotNull Set<String> disallowedSpecial) {
        Regex specialRegex;
        String match;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(allowedSpecial, (String)"allowedSpecial");
        Intrinsics.checkNotNullParameter(disallowedSpecial, (String)"disallowedSpecial");
        Set<String> allowedSpecialSet = allowedSpecial.size() == 1 && Intrinsics.areEqual((Object)CollectionsKt.first((Iterable)allowedSpecial), (Object)"all") ? this.specialTokensSet : allowedSpecial;
        Set disallowedSpecialSet = disallowedSpecial.size() == 1 && Intrinsics.areEqual((Object)CollectionsKt.first((Iterable)disallowedSpecial), (Object)"all") ? SetsKt.minus(this.specialTokensSet, (Iterable)allowedSpecialSet) : disallowedSpecial;
        if (!((Collection)disallowedSpecialSet).isEmpty() && !(((CharSequence)(match = RegexKt.findMatch(text, specialRegex = RegexKt.regexSpecialTokens(disallowedSpecialSet)))).length() == 0)) {
            boolean bl = false;
            String string = "text contains disallowed special token: " + match;
            throw new IllegalArgumentException(string.toString());
        }
        return this.bpe.encode(text, allowedSpecialSet);
    }

    @Override
    public int encodeSingleToken(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.bpe.encodeSingleToken(text);
    }

    @Override
    @NotNull
    public String decode(@NotNull List<Integer> tokens) {
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        return this.bpe.decode(tokens);
    }

    @Override
    @NotNull
    public String decode(int token) {
        return this.bpe.decode(token);
    }
}

