/*
 * Decompiled with CFR 0.152.
 */
package com.aallam.ktoken.internal;

import com.aallam.ktoken.internal.BytePairEncodingKt;
import com.aallam.ktoken.internal.RegexKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"Be\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005J\u0014\u0010\u0015\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019J\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010\u001b\u001a\u00020\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001dJ\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0016J(\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001dH\u0002R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006#"}, d2={"Lcom/aallam/ktoken/internal/CoreBPE;", "", "encoder", "", "Lokio/ByteString;", "", "decoder", "specialTokensEncoder", "specialTokensDecoder", "tlRegex", "Lkotlin/text/Regex;", "tlSpecialRegex", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Lkotlin/text/Regex;Lkotlin/text/Regex;)V", "getDecoder", "()Ljava/util/Map;", "getEncoder", "getSpecialTokensDecoder", "getSpecialTokensEncoder", "getTlRegex", "()Lkotlin/text/Regex;", "getTlSpecialRegex", "decode", "", "token", "tokens", "", "encode", "text", "allowedSpecial", "", "encodeSingleToken", "findNextSpecialToken", "Lkotlin/ranges/IntRange;", "start", "Companion", "ktoken"})
public final class CoreBPE {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<ByteString, Integer> encoder;
    @NotNull
    private final Map<Integer, ByteString> decoder;
    @NotNull
    private final Map<ByteString, Integer> specialTokensEncoder;
    @NotNull
    private final Map<Integer, ByteString> specialTokensDecoder;
    @NotNull
    private final Regex tlRegex;
    @NotNull
    private final Regex tlSpecialRegex;

    public CoreBPE(@NotNull Map<ByteString, Integer> encoder, @NotNull Map<Integer, ? extends ByteString> decoder, @NotNull Map<ByteString, Integer> specialTokensEncoder, @NotNull Map<Integer, ? extends ByteString> specialTokensDecoder, @NotNull Regex tlRegex, @NotNull Regex tlSpecialRegex) {
        Intrinsics.checkNotNullParameter(encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter(decoder, (String)"decoder");
        Intrinsics.checkNotNullParameter(specialTokensEncoder, (String)"specialTokensEncoder");
        Intrinsics.checkNotNullParameter(specialTokensDecoder, (String)"specialTokensDecoder");
        Intrinsics.checkNotNullParameter((Object)tlRegex, (String)"tlRegex");
        Intrinsics.checkNotNullParameter((Object)tlSpecialRegex, (String)"tlSpecialRegex");
        this.encoder = encoder;
        this.decoder = decoder;
        this.specialTokensEncoder = specialTokensEncoder;
        this.specialTokensDecoder = specialTokensDecoder;
        this.tlRegex = tlRegex;
        this.tlSpecialRegex = tlSpecialRegex;
    }

    @NotNull
    public final Map<ByteString, Integer> getEncoder() {
        return this.encoder;
    }

    @NotNull
    public final Map<Integer, ByteString> getDecoder() {
        return this.decoder;
    }

    @NotNull
    public final Map<ByteString, Integer> getSpecialTokensEncoder() {
        return this.specialTokensEncoder;
    }

    @NotNull
    public final Map<Integer, ByteString> getSpecialTokensDecoder() {
        return this.specialTokensDecoder;
    }

    @NotNull
    public final Regex getTlRegex() {
        return this.tlRegex;
    }

    @NotNull
    public final Regex getTlSpecialRegex() {
        return this.tlSpecialRegex;
    }

    @NotNull
    public final String decode(@NotNull List<Integer> tokens) {
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Buffer buffer = new Buffer();
        Iterator<Integer> iterator = tokens.iterator();
        while (iterator.hasNext()) {
            ByteString tokenString;
            int token = ((Number)iterator.next()).intValue();
            ByteString byteString = this.decoder.get(token);
            if (byteString == null) {
                byteString = this.specialTokensDecoder.get(token);
            }
            if ((tokenString = byteString) == null) continue;
            buffer.write(tokenString);
        }
        ByteString byteString = buffer.readByteString();
        return byteString.utf8();
    }

    @NotNull
    public final String decode(int token) {
        ByteString byteString = this.decoder.get(token);
        if (byteString == null && (byteString = this.specialTokensDecoder.get(token)) == null) {
            throw new IllegalStateException(("token missing from the vocabulary: " + token).toString());
        }
        ByteString piece = byteString;
        return piece.utf8();
    }

    @NotNull
    public final List<Integer> encode(@NotNull String text, @NotNull Set<String> allowedSpecial) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(allowedSpecial, (String)"allowedSpecial");
        List encodedTokens = new ArrayList();
        int start = 0;
        while (true) {
            String section;
            IntRange nextSpecial;
            IntRange intRange = nextSpecial = this.findNextSpecialToken(start, text, allowedSpecial);
            int end = intRange != null ? intRange.getFirst() : text.length();
            Intrinsics.checkNotNullExpressionValue((Object)text.substring(start, end), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            List<IntRange> ranges = RegexKt.findAllRanges(section, this.tlRegex);
            for (IntRange range : ranges) {
                ByteString piece = ByteString.Companion.encodeUtf8(StringsKt.substring((String)section, (IntRange)range));
                Integer token = this.encoder.get(piece);
                if (token != null) {
                    encodedTokens.add(token);
                    continue;
                }
                int[] tokens = BytePairEncodingKt.bytePairEncode(piece, this.encoder);
                encodedTokens.addAll(ArraysKt.toList((int[])tokens));
            }
            if (nextSpecial == null) break;
            String specialToken = StringsKt.substring((String)text, (IntRange)nextSpecial);
            ByteString encoded = ByteString.Companion.encodeUtf8(specialToken);
            Integer n = this.specialTokensEncoder.get(encoded);
            if (n == null) {
                throw new IllegalStateException(("token missing from the vocabulary: " + specialToken).toString());
            }
            int token = n;
            encodedTokens.add(token);
            start = nextSpecial.getLast() + 1;
        }
        return encodedTokens;
    }

    private final IntRange findNextSpecialToken(int start, String text, Set<String> allowedSpecial) {
        String token;
        IntRange nextSpecial = null;
        int startFind = start;
        while ((nextSpecial = RegexKt.findIndex(text, startFind, this.tlSpecialRegex)) != null && !allowedSpecial.contains(token = StringsKt.substring((String)text, (IntRange)nextSpecial))) {
            startFind = nextSpecial.getFirst() + 1;
        }
        return nextSpecial;
    }

    public final int encodeSingleToken(@NotNull String text) {
        int n;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ByteString piece = ByteString.Companion.encodeUtf8(text);
        Integer n2 = this.encoder.get(piece);
        if (n2 != null) {
            n = n2;
        } else {
            Integer n3 = this.specialTokensEncoder.get(piece);
            if (n3 != null) {
                n = n3;
            } else {
                throw new IllegalStateException(("token missing from the vocabulary: " + text).toString());
            }
        }
        return n;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/aallam/ktoken/internal/CoreBPE$Companion;", "", "()V", "create", "Lcom/aallam/ktoken/internal/CoreBPE;", "encoder", "", "Lokio/ByteString;", "", "specialTokensEncoder", "pattern", "Lkotlin/text/Regex;", "ktoken"})
    @SourceDebugExtension(value={"SMAP\nCoreBPE.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreBPE.kt\ncom/aallam/ktoken/internal/CoreBPE$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,163:1\n1549#2:164\n1620#2,3:165\n1208#2,2:172\n1238#2,4:174\n125#3:168\n152#3,3:169\n*S KotlinDebug\n*F\n+ 1 CoreBPE.kt\ncom/aallam/ktoken/internal/CoreBPE$Companion\n*L\n148#1:164\n148#1:165,3\n151#1:172,2\n151#1:174,4\n150#1:168\n150#1:169,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CoreBPE create(@NotNull Map<ByteString, Integer> encoder, @NotNull Map<ByteString, Integer> specialTokensEncoder, @NotNull Regex pattern) {
            void $this$associateByTo$iv$iv;
            Object key;
            void $this$mapTo$iv$iv;
            Object object;
            void $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter(encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter(specialTokensEncoder, (String)"specialTokensEncoder");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Iterable $this$map$iv = specialTokensEncoder.keySet();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Iterator it;
                ByteString byteString = (ByteString)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(Regex.Companion.escape(it.utf8()));
            }
            List specialRegexStrs = (List)destination$iv$iv;
            Regex specialRegex = new Regex(CollectionsKt.joinToString$default((Iterable)specialRegexStrs, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null));
            Map<ByteString, Integer> $this$map$iv2 = encoder;
            boolean $i$f$map2 = false;
            Map<ByteString, Integer> $i$f$mapTo22 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo32 = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                Map.Entry entry = item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                key = (ByteString)entry.getKey();
                int value = ((Number)entry.getValue()).intValue();
                object.add(TuplesKt.to((Object)value, (Object)key));
            }
            Map decoder = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            Iterable $this$associateBy$iv = specialTokensEncoder.entrySet();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable $i$f$mapTo32 = $this$associateBy$iv;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                key = (Map.Entry)element$iv$iv;
                object = destination$iv$iv3;
                boolean bl = false;
                Map.Entry it = (Map.Entry)element$iv$iv;
                Integer n = ((Number)it.getValue()).intValue();
                boolean bl2 = false;
                ByteString byteString = (ByteString)it.getKey();
                object.put(n, byteString);
            }
            Map specialTokensDecoder = destination$iv$iv3;
            return new CoreBPE(encoder, decoder, specialTokensEncoder, specialTokensDecoder, pattern, specialRegex);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

