/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.configuration.impl.resourcestatusproviders;

import com.adobe.aem.commons.assetshare.util.ForcedInheritanceValueMapWrapper;
import com.adobe.granite.resourcestatus.ResourceStatus;
import com.adobe.granite.resourcestatus.ResourceStatusProvider;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.commons.status.EditorResourceStatus;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceStatusProvider.class})
@Designate(ocd=Cfg.class)
public class AssetDetailsPageConfigurationResourceStatusProvider
implements ResourceStatusProvider {
    private static final Logger log = LoggerFactory.getLogger(AssetDetailsPageConfigurationResourceStatusProvider.class);
    private static final String STATUS_PROVIDER_TYPE = "asset-share-commons__asset-details-page-configuration";
    private static final String KEY_SHORT_MESSAGE = "shortMessage";
    private static final String VALUE_ICON = "alert";
    private static final String DEFAULT_PAGE_RESOURCE_TYPE = "asset-share-commons/components/structure/details-page";
    private Cfg cfg;

    public String getType() {
        return STATUS_PROVIDER_TYPE;
    }

    public List<ResourceStatus> getStatuses(Resource resource) {
        if (!this.accepts(resource)) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<ResourceStatus> resourceStatuses = new LinkedList<ResourceStatus>();
        EditorResourceStatus.Builder builder = new EditorResourceStatus.Builder(this.getType(), "Missing placeholder asset", "Configure a valid placehold asset on the  Search Page's page properties.");
        builder.setVariant(EditorResourceStatus.Variant.ERROR);
        builder.setIcon(VALUE_ICON);
        builder.setPriority(Integer.valueOf(300000));
        builder.addData(KEY_SHORT_MESSAGE, (Object)"Missing Search Results component");
        resourceStatuses.add((ResourceStatus)builder.build());
        return resourceStatuses;
    }

    private boolean accepts(Resource resource) {
        PageManager pageManager = (PageManager)resource.getResourceResolver().adaptTo(PageManager.class);
        Page page = pageManager.getContainingPage(resource);
        if (page == null || Arrays.stream(this.cfg.pageResourceTypes()).noneMatch(resourceType -> page.getContentResource().isResourceType(resourceType))) {
            return false;
        }
        return !this.hasPlaceholderAsset(resource);
    }

    private boolean hasPlaceholderAsset(Resource resource) {
        PageManager pageManager = (PageManager)resource.getResourceResolver().adaptTo(PageManager.class);
        Page currentPage = pageManager.getContainingPage(resource);
        ForcedInheritanceValueMapWrapper properties = new ForcedInheritanceValueMapWrapper((InheritanceValueMap)new HierarchyNodeInheritanceValueMap(currentPage.getContentResource()));
        String path = (String)properties.get("config/asset-details/placeholderPath", "/apps/asset-share-commons/resources/placeholder.png");
        Resource placeholderResource = resource.getResourceResolver().getResource(path);
        if (placeholderResource != null) {
            return DamUtil.resolveToAsset((Resource)placeholderResource) != null;
        }
        return false;
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Asset Details Page Configuration Status")
    public static @interface Cfg {
        @AttributeDefinition(name="Asset Details Page sling:resourceTypes", description="A list of sling:resourceTypes that identify Asset Details pages.")
        public String[] pageResourceTypes() default {"asset-share-commons/components/structure/details-page"};
    }
}

