/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.configuration.impl.resourcestatusproviders;

import com.adobe.aem.commons.assetshare.util.ResourceTypeVisitor;
import com.adobe.granite.resourcestatus.ResourceStatus;
import com.adobe.granite.resourcestatus.ResourceStatusProvider;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.commons.status.EditorResourceStatus;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceStatusProvider.class})
@Designate(ocd=Cfg.class)
public class SearchPageConfigurationResourceStatusProvider
implements ResourceStatusProvider {
    private static final Logger log = LoggerFactory.getLogger(SearchPageConfigurationResourceStatusProvider.class);
    private static final String STATUS_PROVIDER_TYPE = "asset-share-commons__search-page-configuration";
    private static final String KEY_SHORT_MESSAGE = "shortMessage";
    private static final String VALUE_ICON = "beaker";
    private static final int VALUE_PRIORITY = 200000;
    private static final String DEFAULT_PAGE_RESOURCE_TYPE = "asset-share-commons/components/structure/search-page";
    private static final String DEFAULT_COMPONENT_RESOURCE_TYPE = "asset-share-commons/components/search/results";
    private Cfg cfg;

    public String getType() {
        return STATUS_PROVIDER_TYPE;
    }

    public List<ResourceStatus> getStatuses(Resource resource) {
        if (!this.accepts(resource)) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<ResourceStatus> resourceStatuses = new LinkedList<ResourceStatus>();
        EditorResourceStatus.Builder builder = new EditorResourceStatus.Builder(this.getType(), "Missing Search Results component", "Add a 'Search Results' component to this page.");
        builder.setVariant(EditorResourceStatus.Variant.WARNING);
        builder.setIcon(VALUE_ICON);
        builder.setPriority(Integer.valueOf(200000));
        builder.addData(KEY_SHORT_MESSAGE, (Object)"Missing Search Results component");
        resourceStatuses.add((ResourceStatus)builder.build());
        return resourceStatuses;
    }

    private boolean accepts(Resource resource) {
        PageManager pageManager = (PageManager)resource.getResourceResolver().adaptTo(PageManager.class);
        Page page = pageManager.getContainingPage(resource);
        if (page == null || Arrays.stream(this.cfg.pageResourceTypes()).noneMatch(resourceType -> page.getContentResource().isResourceType(resourceType))) {
            return false;
        }
        ResourceTypeVisitor visitor = new ResourceTypeVisitor(this.cfg.componentResourceTypes());
        visitor.accept(page.getContentResource());
        return visitor.getResources().size() == 0;
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Search Page Configuration Status")
    public static @interface Cfg {
        @AttributeDefinition(name="Search Page sling:resourceTypes", description="A list of sling:resourceTypes that identify the Search Pages.")
        public String[] pageResourceTypes() default {"asset-share-commons/components/structure/search-page"};

        @AttributeDefinition(name="Search Results component sling:resourceTypes", description="A list of sling:resourceTypes that identify the Search Results components.")
        public String[] componentResourceTypes() default {"asset-share-commons/components/search/results"};
    }
}

