/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.impl.datasources;

import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionDispatcher;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionDispatchers;
import com.adobe.aem.commons.assetshare.util.DataSourceBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=asset-share-commons/data-sources/asset-renditions", "sling.servlet.methods=GET"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Cfg.class)
public class AssetRenditionsDataSource
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(AssetRenditionsDataSource.class);
    private static final String PN_EXCLUDE_ASSETRENDITIONS = "excludeAssetRenditions";
    private static final String PN_EXCLUDE_ASSETRENDITIONDISPATCHERS = "excludeAssetRenditionDispatchers";
    private static final String PN_ALLOWED_ASSETRENDITIONDISPATCHER_TYPES = "allowedAssetRenditionTypes";
    private static final String PN_ADD_ASSET_RENDITION_DISPATCHER_TO_LABEL = "addAssetRenditionDispatcherToLabel";
    @Reference
    private transient DataSourceBuilder dataSourceBuilder;
    @Reference
    private transient AssetRenditionDispatchers assetRenditionDispatchers;
    private transient Cfg cfg;

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        TreeMap<String, Object> data = new TreeMap<String, Object>();
        ValueMap properties = request.getResource().getValueMap();
        List<String> allowedAssetRenditionTypes = Arrays.asList((String[])properties.get(PN_ALLOWED_ASSETRENDITIONDISPATCHER_TYPES, (Object)new String[0]));
        Set<String> excludeAssetRenditionDispatchers = this.getExcluded(properties, this.cfg.exclude_assetrenditiondispatcher_names(), PN_EXCLUDE_ASSETRENDITIONDISPATCHERS);
        Set<String> excludeAssetRenditions = this.getExcluded(properties, this.cfg.exclude_assetrendition_names(), PN_EXCLUDE_ASSETRENDITIONS);
        boolean addAssetRenditionDispatcherToLabel = (Boolean)properties.get(PN_ADD_ASSET_RENDITION_DISPATCHER_TO_LABEL, (Object)this.cfg.add_assetrenditiondispatcher_to_label());
        for (AssetRenditionDispatcher assetRenditionDispatcher : this.assetRenditionDispatchers.getAssetRenditionDispatchers()) {
            if (!this.acceptsAssetRenditionDispatcher(allowedAssetRenditionTypes, excludeAssetRenditionDispatchers, assetRenditionDispatcher)) continue;
            assetRenditionDispatcher.getOptions().entrySet().stream().filter(entry -> !excludeAssetRenditions.contains(entry.getValue())).filter(entry -> !data.containsValue(entry.getValue())).forEach(entry -> {
                String label = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (addAssetRenditionDispatcherToLabel) {
                    label = label + " (" + assetRenditionDispatcher.getLabel() + ")";
                }
                data.put(label, value);
            });
        }
        this.dataSourceBuilder.build(request, data);
    }

    private boolean acceptsAssetRenditionDispatcher(List<String> allowedAssetRenditionTypes, Set<String> excludeAssetRenditionDispatchers, AssetRenditionDispatcher assetRenditionDispatcher) {
        if (!assetRenditionDispatcher.getTypes().isEmpty() && !allowedAssetRenditionTypes.isEmpty() && Collections.disjoint(assetRenditionDispatcher.getTypes(), allowedAssetRenditionTypes)) {
            if (log.isDebugEnabled()) {
                log.debug("Skip adding AssetRenditionDispatcher factory [ {} ] to Data Source as it does not have any allowed types", (Object)assetRenditionDispatcher.getName());
            }
            return false;
        }
        if (assetRenditionDispatcher.isHidden()) {
            if (log.isDebugEnabled()) {
                log.debug("Skip adding AssetRenditionDispatcher factory [ {} ] to Data Source as it has been marked as hidden via configuration", (Object)assetRenditionDispatcher.getName());
            }
            return false;
        }
        if (excludeAssetRenditionDispatchers.contains(assetRenditionDispatcher.getName())) {
            if (log.isDebugEnabled()) {
                log.debug("Skip adding AssetRenditionDispatcher factory [ {} ] to Data Source as it has been excluded via configuration", (Object)assetRenditionDispatcher.getName());
            }
            return false;
        }
        return true;
    }

    private Set<String> getExcluded(ValueMap properties, String[] excludedViaOsgiConfig, String excludedPropertyName) {
        HashSet<String> excluded = new HashSet<String>();
        if (excludedViaOsgiConfig != null) {
            excluded.addAll(Arrays.asList(excludedViaOsgiConfig));
        }
        excluded.addAll(Arrays.asList((String[])properties.get(excludedPropertyName, (Object)new String[0])));
        return excluded;
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Data Sources - Asset Renditions")
    public static @interface Cfg {
        @AttributeDefinition(name="Exclude AssetRenditionDispatchers (by name)", description="Exclude the listed AssetRenditionDispatcher's from populating this data source.")
        public String[] exclude_assetrenditiondispatcher_names() default {};

        @AttributeDefinition(name="Exclude Asset Renditions (by name)", description="Exclude the listed Rendition Names's from populating this data source. (This is agnostic to which AssetRenditionDispatcher defined them).")
        public String[] exclude_assetrendition_names() default {"card", "list"};

        @AttributeDefinition(name="Display AssetRenditionDispatcher names in labels", description="Select to include the AssetRenditionDispatcher's name in the DataSource's labels. Adds in formatAssetRendition name (AssetRenditionDispatcher label)")
        public boolean add_assetrenditiondispatcher_to_label() default false;
    }
}

