/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.properties.impl;

import com.adobe.aem.commons.assetshare.content.properties.AbstractComputedProperty;
import com.adobe.aem.commons.assetshare.content.properties.ComputedProperty;
import com.day.cq.dam.api.Asset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ComputedProperty.class}, property={"service.ranking=-1"})
@Designate(ocd=Cfg.class)
public class ContentTypeImpl
extends AbstractComputedProperty<String> {
    public static final String LABEL = "Content Type";
    public static final String NAME = "content-type";
    private Cfg cfg;
    private static final Map<String, String> mimeTypeToLabelMap = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("image/vnd.adobe.photoshop", "Photoshop");
            this.put("application/msword", "Word Doc");
            this.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "Word Doc");
            this.put("application/vnd.ms-excel", "Excel");
            this.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "Excel");
            this.put("application/vnd.ms-powerpoint", "PowerPoint");
            this.put("application/vnd.openxmlformats-officedocument.presentationml.presentation", "PowerPoint");
            this.put("application/pdf", "PDF");
            this.put("application/xml", "XML");
            this.put("application/zip", "Zip");
            this.put("application/json", "JSON");
            this.put("application/vnd.adobe.illustrator", "Illustrator");
            this.put("application/vnd.adobe.indesign", "InDesign");
            this.put("application/vnd.adobe.indesignml", "InDesign");
            this.put("application/vnd.adobe.indesignx", "InDesign");
            this.put("application/vnd.adobe.aftereffects", "After Effects");
            this.put("application/vnd.adobe.premiere", "Premiere");
            this.put("application/vnd.adobe.xd", "XD");
            this.put("text/html", "HTML");
            this.put("text/csv", "CSV");
        }
    });
    private static final Map<String, String> mimeTypePrefixToLabelMap = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("image", "Image");
            this.put("video", "Video");
            this.put("audio", "Audio");
            this.put("font", "Font");
            this.put("model", "3D");
            this.put("text", "Text");
        }
    });

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return this.cfg.label();
    }

    @Override
    public String[] getTypes() {
        return this.cfg.types();
    }

    @Override
    public String get(Asset asset) {
        String mimeType = (String)StringUtils.defaultIfBlank((CharSequence)asset.getMimeType(), (CharSequence)"");
        String value = mimeTypeToLabelMap.get(mimeType);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = mimeTypePrefixToLabelMap.get(StringUtils.substringBefore((String)mimeType, (String)"/"));
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            value = (String)StringUtils.defaultIfBlank((CharSequence)this.cfg.unknownLabel(), (CharSequence)"");
        }
        return value;
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Computed Property - Content Type")
    public static @interface Cfg {
        @AttributeDefinition(name="Label", description="Human read-able label.")
        public String label() default "Content Type";

        @AttributeDefinition(name="Types", description="Defines the type of data this exposes. This classification allows for intelligent exposure of Computed Properties in DataSources, etc.")
        public String[] types() default {"metadata"};

        @AttributeDefinition(name="Unknown Label", description="Defaults to blank so it can be trivially handled via HTL existence checks.")
        public String unknownLabel() default "";
    }
}

