/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.util.assetkit.impl;

import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.util.assetkit.AssetKitHelper;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.Page;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.resource.collection.ResourceCollection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class AssetKitHelperImpl
implements AssetKitHelper {
    @Reference
    private transient QueryBuilder queryBuilder;
    @Reference
    private transient ModelFactory modelFactory;

    public Collection<AssetModel> getAssets(ResourceResolver resourceResolver, String[] paths) {
        Resource[] resources = Arrays.stream(paths).map(path -> resourceResolver.getResource(path)).collect(Collectors.toList()).toArray(new Resource[0]);
        return this.getAssets(resources);
    }

    public Collection<AssetModel> getAssets(Resource[] resources) {
        ArrayList<AssetModel> assets = new ArrayList<AssetModel>();
        for (Resource resource : resources) {
            if (resource == null) continue;
            if (this.isAsset(resource)) {
                assets.add(this.getAsset(resource));
                continue;
            }
            if (this.isAssetFolder(resource)) {
                assets.addAll(this.getAssetsFromAssetFolder(resource));
                continue;
            }
            if (!this.isAssetCollection(resource)) continue;
            assets.addAll(this.getAssetsFromAssetCollection(resource));
        }
        return assets;
    }

    @Override
    public Collection<? extends AssetModel> getAssetsFromAssetCollection(Resource resource) {
        ArrayList<AssetModel> assets = new ArrayList<AssetModel>();
        ResourceCollection resourceCollection = (ResourceCollection)resource.adaptTo(ResourceCollection.class);
        if (null != resourceCollection) {
            Iterator resourceIterator = resourceCollection.getResources();
            while (resourceIterator.hasNext()) {
                Resource collectionResource = (Resource)resourceIterator.next();
                if (!this.isAsset(collectionResource)) continue;
                assets.add(this.getAsset(collectionResource));
            }
        }
        return assets;
    }

    @Override
    public Collection<? extends AssetModel> getAssetsFromAssetFolder(Resource resource) {
        ArrayList assets = new ArrayList();
        resource.getChildren().forEach(child -> {
            if (!"jcr:content".equals(child.getName()) && this.isAsset((Resource)child)) {
                assets.add(this.getAsset((Resource)child));
            }
        });
        return assets;
    }

    @Override
    public AssetModel getAsset(Resource resource) {
        return (AssetModel)this.modelFactory.createModel((Object)resource, AssetModel.class);
    }

    @Override
    public boolean isAssetFolder(Resource resource) {
        return resource != null && StringUtils.startsWith((CharSequence)resource.getPath(), (CharSequence)"/content/dam/") && (resource.getResourceType().equals("sling:Folder") || resource.getResourceType().equals("sling:OrderedFolder") || resource.getResourceType().equals("nt:folder"));
    }

    @Override
    public boolean isAssetCollection(Resource resource) {
        return resource != null && StringUtils.startsWith((CharSequence)resource.getPath(), (CharSequence)"/content/dam/collections/") && resource.adaptTo(ResourceCollection.class) != null;
    }

    @Override
    public boolean isAsset(Resource resource) {
        return resource != null && DamUtil.isAsset((Resource)resource);
    }

    @Override
    public void updateComponentOnPage(Page page, String resourceType, String propertyName, String propertyValue) throws PersistenceException, RepositoryException {
        Resource resource = this.findResourceByResourceType(page, resourceType);
        if (resource != null) {
            ModifiableValueMap properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            if (properties.keySet().contains(propertyName)) {
                properties.remove((Object)propertyName);
            }
            properties.put((Object)propertyName, (Object)propertyValue);
        }
    }

    public Resource findResourceByResourceType(Page page, String resourceType) throws RepositoryException {
        ResourceResolver resourceResolver = page.getContentResource().getResourceResolver();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("path", page.getContentResource().getPath());
        map.put("path.self", "true");
        map.put("property", "sling:resourceType");
        map.put("property.value", resourceType);
        map.put("p.limit", "1");
        Query query = this.queryBuilder.createQuery(PredicateGroup.create(map), (Session)resourceResolver.adaptTo(Session.class));
        SearchResult result = query.getResult();
        if (result.getHits().size() > 0) {
            return resourceResolver.getResource(((Hit)result.getHits().get(0)).getPath());
        }
        return null;
    }
}

