/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.actions.download.impl;

import com.adobe.aem.commons.assetshare.components.actions.ActionHelper;
import com.adobe.aem.commons.assetshare.components.actions.AssetDownloadHelper;
import com.adobe.aem.commons.assetshare.components.actions.download.Download;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionDispatchers;
import com.adobe.aem.commons.assetshare.util.RequireAem;
import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.form.OptionItem;
import com.adobe.cq.wcm.core.components.models.form.Options;
import com.day.cq.dam.commons.util.UIHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.apache.sling.models.factory.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Download.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/modals/download"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@Exporter(name="jackson", extensions={"json"})
public class DownloadImpl
implements Download,
ComponentExporter {
    private static final Logger log = LoggerFactory.getLogger(DownloadImpl.class);
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/modals/download";
    private static final long DEFAULT_SIZE_LIMIT = -1L;
    private static final String NN_ASSET_RENDITIONS_GROUPS = "asset-renditions-groups";
    public static final String PN_ASSET_RENDITIONS_GROUP_TITLE = "assetRenditionsGroupTitle";
    public static final String PN_ARCHIVE_FILE_NAME_EXPRESSION = "archiveFileExpression";
    public static final String NN_ASSET_RENDITIONS = "asset-renditions";
    public static final String NN_ITEMS = "items";
    public static final String DEFAULT_ARCHIVE_FILE_NAME_EXPRESSION = "${asset.name.no-extension}/${asset.name.no-extension} (${rendition.name})";
    @Self
    @Required
    protected SlingHttpServletRequest request;
    @OSGiService
    @Required
    private RequireAem requireAem;
    @ValueMapValue
    @Default(values={"Assets"})
    protected String zipFileName;
    @OSGiService
    @Required
    protected ActionHelper actionHelper;
    @OSGiService
    @Required
    protected AssetDownloadHelper assetDownloadHelper;
    @OSGiService
    @Required
    private ModelFactory modelFactory;
    @OSGiService
    @Required
    private AssetRenditionDispatchers assetRenditionDispatchers;
    @ValueMapValue
    private Boolean legacyMode;
    @Deprecated
    @ValueMapValue
    private Boolean excludeOriginalAssets;
    protected List<Download.AssetRenditionsGroup> assetRenditionsGroups = null;
    protected Collection<AssetModel> assets = null;
    protected Long maxContentSize = -1L;
    protected Long downloadContentSize = -1L;

    @PostConstruct
    protected void init() {
        if (this.requireAem != null) {
            if (log.isDebugEnabled()) {
                log.debug("Initing DownloadImpl withe RequireAem configurations: [ distribution = {} ] and [ serviceType = {} ]", (Object)this.requireAem.getDistribution().getValue(), (Object)this.requireAem.getServiceType().getValue());
            }
        } else {
            log.error("Initing DownloadImpl with injected requireAEM service as null");
        }
        this.assets = this.actionHelper.getAssetsFromQueryParameter(this.request, "path");
        if (this.assets.isEmpty()) {
            this.assets = this.actionHelper.getPlaceholderAsset(this.request);
        } else if (RequireAem.Distribution.CLASSIC.equals((Object)this.requireAem.getDistribution())) {
            try {
                this.calculateSizes();
            }
            catch (NullPointerException e) {
                log.error("An NPE is known to be thrown by AEM in conditions where Dynamic Media is enabled and/or the asset has Dynamic Media attributes when trying to compute sizes.");
            }
        }
    }

    @Override
    public List<Download.AssetRenditionsGroup> getAssetRenditionsGroups() {
        if (this.assetRenditionsGroups == null) {
            this.assetRenditionsGroups = new ArrayList<Download.AssetRenditionsGroup>();
            Optional.ofNullable(this.request.getResource().getChild("asset-renditions-groups/items")).ifPresent(groups -> groups.getChildren().forEach(child -> this.getAssetRenditionGroup(child.getChild(NN_ASSET_RENDITIONS)).ifPresent(arg -> this.assetRenditionsGroups.add((Download.AssetRenditionsGroup)arg))));
        }
        return Collections.unmodifiableList(this.assetRenditionsGroups);
    }

    private Optional<Download.AssetRenditionsGroup> getAssetRenditionGroup(Resource group) {
        Optional<Download.AssetRenditionsGroup> assetRenditionsGroup = Optional.empty();
        if (group != null) {
            String title = (String)group.getParent().getValueMap().get(PN_ASSET_RENDITIONS_GROUP_TITLE, String.class);
            Options options = (Options)this.modelFactory.getModelFromWrappedRequest(this.request, group, Options.class);
            Optional<List<List>> sanitizedOptions = Optional.of(options.getItems().stream().filter(item -> this.assetRenditionDispatchers.isValidAssetRenditionName(item.getValue())).collect(Collectors.toList()));
            assetRenditionsGroup = sanitizedOptions.filter(so -> !so.isEmpty()).map(so -> new Download.AssetRenditionsGroup(title, (List<OptionItem>)so));
        }
        return assetRenditionsGroup;
    }

    @Override
    public Collection<AssetModel> getAssets() {
        return Collections.unmodifiableCollection(this.assets);
    }

    @Override
    public String getZipFileName() {
        return StringUtils.removeEndIgnoreCase((String)this.zipFileName, (String)".zip");
    }

    @Override
    public long getMaxContentSize() {
        return this.maxContentSize;
    }

    @Override
    public long getDownloadContentSize() {
        return this.downloadContentSize;
    }

    @Override
    public String getMaxContentSizeLabel() {
        return UIHelper.getSizeLabel((double)this.getMaxContentSize(), (SlingHttpServletRequest)this.request);
    }

    @Override
    public String getDownloadContentSizeLabel() {
        return UIHelper.getSizeLabel((double)this.getDownloadContentSize(), (SlingHttpServletRequest)this.request);
    }

    @Override
    public boolean isAsynchronous() {
        return RequireAem.Distribution.CLOUD_READY.equals((Object)this.requireAem.getDistribution());
    }

    @Override
    @Deprecated
    public boolean isLegacyMode() {
        if (this.legacyMode == null) {
            if (this.getAssetRenditionsGroups() != null && !this.getAssetRenditionsGroups().isEmpty()) {
                return false;
            }
            return this.excludeOriginalAssets != null;
        }
        return this.legacyMode;
    }

    @Deprecated
    private void calculateSizes() {
        this.maxContentSize = this.assetDownloadHelper.getMaxContentSizeLimit();
        log.debug("Max allowed content size (in bytes) [ {} ]", (Object)this.maxContentSize);
        if (this.maxContentSize > 0L) {
            log.debug("Max content size set, requires calculation of download  content size.");
            this.downloadContentSize = this.assetDownloadHelper.getAssetDownloadSize(this.assets, this.request.getResource());
            log.debug("Requested download content size (in bytes) [ {} ]", (Object)this.downloadContentSize);
        } else {
            this.downloadContentSize = -1L;
        }
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

