/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.predicates.impl;

import com.adobe.aem.commons.assetshare.components.predicates.AbstractPredicate;
import com.adobe.aem.commons.assetshare.components.predicates.TagsPredicate;
import com.adobe.aem.commons.assetshare.components.predicates.impl.options.TagOptionItem;
import com.adobe.aem.commons.assetshare.configuration.Config;
import com.adobe.aem.commons.assetshare.util.PredicateUtil;
import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.form.Field;
import com.adobe.cq.wcm.core.components.models.form.OptionItem;
import com.adobe.cq.wcm.core.components.models.form.Options;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={TagsPredicate.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/search/tags"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@Exporter(name="jackson", extensions={"json"})
public class TagsPredicateImpl
extends AbstractPredicate
implements TagsPredicate {
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/search/tags";
    private static final String SORT_ALPHABETICAL = "alphabetical";
    private static final String SORT_NATURAL = "natural";
    @Self
    @Required
    SlingHttpServletRequest request;
    @Self
    @Required
    private Options coreOptions;
    @ValueMapValue(name="type")
    private String typeString;
    @ValueMapValue
    private String property;
    @ValueMapValue
    @Named(value="and")
    @Default(booleanValues={false})
    private boolean and;
    @ValueMapValue
    @Default(values={"natural"})
    private String displayOrder;
    @ValueMapValue
    @Default(values={"equals"})
    private String operation;
    private String valueFromRequest;
    private ValueMap valuesFromRequest;

    @PostConstruct
    protected void init() {
        this.initPredicate(this.request, (Field)this.coreOptions);
    }

    @Override
    public Options.Type getType() {
        return this.coreOptions.getType();
    }

    @Override
    public String getSubType() {
        return this.typeString;
    }

    @Override
    public String getProperty() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.property, (CharSequence)"jcr:content/metadata/cq:tags");
    }

    public String getName() {
        return "propertyvalues";
    }

    @Override
    public String getValuesKey() {
        return "values";
    }

    @Override
    public boolean hasOperation() {
        return StringUtils.isNotBlank((CharSequence)this.operation);
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    public boolean hasAnd() {
        return this.and;
    }

    @Override
    public Boolean getAnd() {
        return this.and;
    }

    @Override
    public List<OptionItem> getItems() {
        ArrayList<OptionItem> items = new ArrayList<OptionItem>();
        TagManager tagManager = (TagManager)this.request.getResourceResolver().adaptTo(TagManager.class);
        Tag[] tags = tagManager.getTags(this.request.getResource());
        if (tags != null) {
            ValueMap initialValues = this.getInitialValues();
            Locale locale = ((Config)this.request.adaptTo(Config.class)).getLocale();
            for (Tag tag : tags) {
                items.add(new TagOptionItem(tag, locale, PredicateUtil.isOptionInInitialValues(tag.getTagID(), initialValues)));
            }
        }
        if (SORT_ALPHABETICAL.equals(this.displayOrder)) {
            Collections.sort(items, new AbstractPredicate.AlphabeticalOptionItems(this));
        }
        return items;
    }

    @Override
    public boolean isReady() {
        TagManager tagManager = (TagManager)this.request.getResourceResolver().adaptTo(TagManager.class);
        return tagManager.getTags(this.request.getResource()).length > 0;
    }

    @Override
    public String getInitialValue() {
        if (this.valueFromRequest == null) {
            this.valueFromRequest = PredicateUtil.getInitialValue(this.request, this, "values");
        }
        return this.valueFromRequest;
    }

    @Override
    public ValueMap getInitialValues() {
        if (this.valuesFromRequest == null) {
            this.valuesFromRequest = PredicateUtil.getInitialValues(this.request, this, "values");
        }
        return this.valuesFromRequest;
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

