/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.search.providers.impl;

import com.adobe.aem.commons.assetshare.components.predicates.PagePredicate;
import com.adobe.aem.commons.assetshare.search.SearchSafety;
import com.adobe.aem.commons.assetshare.search.UnsafeSearchException;
import com.adobe.aem.commons.assetshare.search.providers.QuerySearchPostProcessor;
import com.adobe.aem.commons.assetshare.search.providers.QuerySearchPreProcessor;
import com.adobe.aem.commons.assetshare.search.providers.SearchProvider;
import com.adobe.aem.commons.assetshare.search.results.AssetResult;
import com.adobe.aem.commons.assetshare.search.results.Result;
import com.adobe.aem.commons.assetshare.search.results.Results;
import com.adobe.aem.commons.assetshare.search.results.impl.results.QueryBuilderResultsImpl;
import com.adobe.aem.commons.assetshare.util.PredicateUtil;
import com.day.cq.search.PredicateConverter;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.factory.ModelFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.ranking:Integer=-2147483648"})
public class QuerySearchProviderImpl
implements SearchProvider {
    private static final Logger log = LoggerFactory.getLogger(QuerySearchProviderImpl.class);
    @Reference
    private transient SearchSafety searchSafety;
    @Reference
    private transient QueryBuilder queryBuilder;
    @Reference
    private transient ModelFactory modelFactory;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    private transient QuerySearchPreProcessor querySearchPreProcessor;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    private transient QuerySearchPostProcessor querySearchPostProcessor;

    @Override
    public boolean accepts(SlingHttpServletRequest request) {
        return true;
    }

    @Override
    public Results getResults(SlingHttpServletRequest request) throws UnsafeSearchException, RepositoryException {
        ResourceResolver resourceResolver = request.getResourceResolver();
        PredicateGroup root = this.querySearchPreProcessor != null ? this.querySearchPreProcessor.process(request, this.getParams(request)) : PredicateGroup.create(this.getParams(request));
        if (!this.searchSafety.isSafe(request.getResourceResolver(), root)) {
            throw new UnsafeSearchException("Search query will initiate an traversing query");
        }
        this.debugPreQuery(root);
        Query query = this.queryBuilder.createQuery(root, (Session)resourceResolver.adaptTo(Session.class));
        SearchResult searchResult = query.getResult();
        this.debugPostQuery(searchResult);
        ArrayList<Result> results = new ArrayList<Result>();
        ResourceResolver resourceResolverLeakingReference = null;
        for (Hit hit : searchResult.getHits()) {
            if (resourceResolverLeakingReference == null) {
                resourceResolverLeakingReference = hit.getResource().getResourceResolver();
            }
            try {
                Resource hitResource = resourceResolver.getResource(hit.getPath());
                AssetResult assetSearchResult = (AssetResult)this.modelFactory.getModelFromWrappedRequest(request, hitResource, AssetResult.class);
                if (assetSearchResult == null) continue;
                results.add(assetSearchResult);
            }
            catch (RepositoryException e) {
                log.error("Could not retrieve search result", (Throwable)e);
            }
        }
        if (resourceResolverLeakingReference != null) {
            resourceResolverLeakingReference.close();
        }
        this.debugPostAdaptation(results);
        QueryBuilderResultsImpl resultsImpl = new QueryBuilderResultsImpl(results, searchResult);
        if (this.querySearchPostProcessor != null) {
            return this.querySearchPostProcessor.process(request, query, resultsImpl, searchResult);
        }
        return resultsImpl;
    }

    private Map<String, String> getParams(SlingHttpServletRequest request) {
        Map<String, String> params = new HashMap<String, String>();
        for (Map.Entry entry2 : request.getRequestParameterMap().entrySet()) {
            params.put((String)entry2.getKey(), ((RequestParameter[])entry2.getValue())[0].getString().trim());
        }
        this.cleanParams(params);
        PagePredicate pagePredicate = (PagePredicate)request.adaptTo(PagePredicate.class);
        PredicateGroup paramsPredicateGroup = PredicateConverter.createPredicates(params);
        PagePredicate.ParamTypes[] excludeParamTypes = new PagePredicate.ParamTypes[]{};
        if (this.isPathsProvidedByRequestParams(pagePredicate, params)) {
            String[] allowedPathPrefixes = (String[])pagePredicate.getPaths().stream().map(path -> StringUtils.removeEnd((String)path, (String)"/") + "/").toArray(String[]::new);
            HashMap<String, String> tmpParams = params;
            PredicateUtil.findPredicate(params, "path", "path").entrySet().stream().filter(entry -> !StringUtils.startsWithAny((CharSequence)((String)entry.getValue()), (CharSequence[])allowedPathPrefixes)).forEach(entry -> tmpParams.remove(entry.getKey()));
            params = tmpParams;
        }
        if (this.isPathsProvidedByRequestParams(pagePredicate, params)) {
            excludeParamTypes = new PagePredicate.ParamTypes[]{PagePredicate.ParamTypes.PATH};
        }
        PredicateGroup combinedPredicateGroup = this.safeMerge(paramsPredicateGroup, pagePredicate.getPredicateGroup(excludeParamTypes));
        params = PredicateConverter.createMap((PredicateGroup)combinedPredicateGroup);
        return params;
    }

    private boolean isPathsProvidedByRequestParams(PagePredicate pagePredicate, Map<String, String> requestParams) {
        ValueMap pathPredicates = PredicateUtil.findPredicate(requestParams, "path", "path");
        if (pathPredicates.size() == 0) {
            return false;
        }
        List<String> allowedPaths = pagePredicate.getPaths();
        CharSequence[] allowedPathPrefixes = (String[])pagePredicate.getPaths().stream().map(path -> StringUtils.removeEnd((String)path, (String)"/") + "/").toArray(String[]::new);
        boolean hasAllowed = false;
        for (String key : pathPredicates.keySet()) {
            String path2 = Text.makeCanonicalPath((String)((String)pathPredicates.get(key, String.class)));
            if (StringUtils.startsWithAny((CharSequence)path2, (CharSequence[])allowedPathPrefixes) || allowedPaths.contains(path2)) {
                hasAllowed = true;
                continue;
            }
            requestParams.remove(key);
        }
        return hasAllowed;
    }

    private void cleanParams(Map<String, String> params) {
        params.remove("p.guessTotal");
        params.remove("mode");
        params.remove("layout");
        params.remove("wcmmode");
        params.remove("forceeditcontext");
    }

    private PredicateGroup safeMerge(PredicateGroup src, PredicateGroup dest) {
        PredicateGroup merged = dest.clone();
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(src.iterator(), 16), false).forEach(predicate -> {
            if (!"p".equals(predicate.getName()) && "group".equals(predicate.getType())) {
                merged.add(predicate.clone(true));
            } else {
                merged.add(predicate.clone(false));
            }
        });
        return merged;
    }

    private void debugPreQuery(PredicateGroup predicateGroup) {
        if (log.isDebugEnabled()) {
            TreeMap sortedParams = new TreeMap();
            sortedParams.putAll(PredicateConverter.createMap((PredicateGroup)predicateGroup));
            StringBuilder sb = new StringBuilder();
            for (Map.Entry parameter : sortedParams.entrySet()) {
                sb.append((String)parameter.getKey() + " = " + (String)parameter.getValue() + " | ");
            }
            log.debug("Query Builder Parameters: {}", (Object)sb.toString());
        }
    }

    private void debugPostQuery(SearchResult searchResult) {
        if (log.isDebugEnabled()) {
            log.debug("Executed query statement:\n{}", (Object)searchResult.getQueryStatement());
            log.debug("Search results - Hits size [ {} ]", (Object)searchResult.getHits().size());
            log.debug("Search results - Page count [ {} ]", (Object)searchResult.getResultPages().size());
            log.debug("Search results - Page start index [ {} ]", (Object)searchResult.getStartIndex());
            log.debug("Search results - Running total [ {} ]", (Object)(searchResult.getStartIndex() + (long)searchResult.getHits().size()));
            log.debug("Search results - Has more results [ {} ]", (Object)searchResult.hasMore());
            log.debug("Search results - Total matches [ {} ]", (Object)searchResult.getTotalMatches());
            log.debug("Search results - Execution time in ms [ {} ]", (Object)searchResult.getExecutionTimeMillis());
        }
    }

    private void debugPostAdaptation(List<Result> results) {
        if (log.isDebugEnabled()) {
            log.debug("Adapted [ {} ] results to Result models", (Object)results.size());
        }
    }
}

