/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.details.impl;

import com.adobe.aem.commons.assetshare.components.details.Pdf;
import com.adobe.aem.commons.assetshare.components.details.impl.AbstractEmptyTextComponent;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionParameters;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditions;
import com.adobe.aem.commons.assetshare.util.AdobePdfEmbedApi;
import com.adobe.aem.commons.assetshare.util.RequireAem;
import com.adobe.aem.commons.assetshare.util.UrlUtil;
import com.adobe.cq.export.json.ComponentExporter;
import com.day.cq.wcm.api.designer.Style;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Pdf.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/details/pdf"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@Exporter(name="jackson", extensions={"json"})
public class PdfImpl
extends AbstractEmptyTextComponent
implements Pdf {
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/details/pdf";
    private static final String SIZED_CONTAINER = "SIZED_CONTAINER";
    private static final String IN_LINE = "IN_LINE";
    private static final String FULL_WINDOW = "FULL_WINDOW";
    @Self
    @Required
    private SlingHttpServletRequest request;
    @Self
    @Required
    private AssetModel asset;
    @OSGiService
    @Required
    private AssetRenditions assetRenditions;
    @OSGiService
    @Required
    private RequireAem requireAem;
    @OSGiService
    @Optional
    private AdobePdfEmbedApi adobePdfEmbedApi;
    @ValueMapValue
    private String renditionName;
    @ScriptVariable
    private Style currentStyle;
    private String src = null;
    private String viewerId = null;
    private String clientId = null;
    private ValueMap properties = new ValueMapDecorator(new HashMap());

    @PostConstruct
    public void init() {
        this.properties = this.request.getResource().getValueMap();
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.getSrc()) || StringUtils.isBlank((CharSequence)this.getClientId());
    }

    @Override
    public boolean isReady() {
        return !this.isEmpty();
    }

    @Override
    public String getSrc() {
        if (this.src == null) {
            String tmp = null;
            if (this.asset != null && StringUtils.isNotBlank((CharSequence)this.renditionName)) {
                AssetRenditionParameters parameters = new AssetRenditionParameters(this.asset, this.renditionName, false);
                tmp = this.assetRenditions.getUrl(this.request, this.asset, parameters);
            }
            this.src = UrlUtil.escape(tmp);
        }
        return this.src;
    }

    @Override
    public String getFileName() {
        return this.asset.getName();
    }

    @Override
    public String getClientId() {
        if (this.clientId == null) {
            this.clientId = RequireAem.ServiceType.AUTHOR.equals((Object)this.requireAem.getServiceType()) ? (String)this.currentStyle.get("authorClientId", (Object)((String)this.currentStyle.get("clientId", String.class))) : (String)this.currentStyle.get("publishClientId", (Object)((String)this.currentStyle.get("clientId", String.class)));
            if (StringUtils.isBlank((CharSequence)this.clientId) && this.adobePdfEmbedApi != null) {
                this.clientId = this.adobePdfEmbedApi.getClientId();
            }
        }
        return this.clientId;
    }

    @Override
    public String getViewerId() {
        if (this.viewerId == null) {
            this.viewerId = "asset_share_commons__adobe_dc_view__" + StringUtils.replace((String)StringUtils.lowerCase((String)UUID.randomUUID().toString()), (String)"-", (String)"");
        }
        return this.viewerId;
    }

    @Override
    public String getEmbedMode() {
        return (String)this.properties.get("embedMode", (Object)SIZED_CONTAINER);
    }

    @Override
    public String getDefaultViewMode() {
        return (String)this.properties.get("defaultViewMode", (Object)"FIT_WIDTH");
    }

    @Override
    public String getHeight() {
        int height = this.getEmbedModeProperty("height", 100);
        if (height > 100) {
            return height + "px";
        }
        return "auto";
    }

    @Override
    public boolean isReadOnly() {
        return this.getEmbedModeProperty("hasReadOnlyAccess", true);
    }

    @Override
    public boolean showFullScreen() {
        return this.getEmbedModeProperty("showFullScreen", false);
    }

    @Override
    public boolean showDownload() {
        return this.getEmbedModeProperty("showDownloadPDF", false);
    }

    @Override
    public boolean showPrint() {
        return this.getEmbedModeProperty("showPrintPDF", false);
    }

    @Override
    public boolean showZoomControl() {
        return this.getEmbedModeProperty("showZoomControl", false);
    }

    @Override
    public boolean showBookmarks() {
        return this.getEmbedModeProperty("showBookmarks", false);
    }

    @Override
    public boolean showAnnotationTools() {
        return this.getEmbedModeProperty("showAnnotationTools", false);
    }

    @Override
    public boolean isLinearizationEnabled() {
        return (Boolean)this.properties.get("enableLinearization", (Object)false);
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }

    private <T> T getEmbedModeProperty(String propertyName, T defaultValue) {
        String embedMode = StringUtils.replace((String)this.getEmbedMode(), (String)"_", (String)"-").toLowerCase();
        Object value = this.properties.get(embedMode + "/" + propertyName, defaultValue);
        return (T)value;
    }
}

