/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.predicates.impl;

import com.adobe.aem.commons.assetshare.components.predicates.AbstractPredicate;
import com.adobe.aem.commons.assetshare.components.predicates.SortPredicate;
import com.adobe.aem.commons.assetshare.components.predicates.impl.options.SortOptionItem;
import com.adobe.aem.commons.assetshare.components.search.SearchConfig;
import com.adobe.aem.commons.assetshare.util.PredicateUtil;
import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.form.Field;
import com.adobe.cq.wcm.core.components.models.form.OptionItem;
import com.adobe.cq.wcm.core.components.models.form.Options;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={SortPredicate.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/search/sort"})
@Exporter(name="jackson", extensions={"json"})
public class SortPredicateImpl
extends AbstractPredicate
implements SortPredicate {
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/search/sort";
    private static final String NAME_ORDER_BY = "orderby";
    private static final String NN_ITEMS = "items";
    private static final String PN_TEXT = "text";
    private static final String PN_VALUE = "value";
    private static final String PN_ORDER_BY_CASE = "orderByCase";
    protected ValueMap valuesFromRequest = null;
    private static final String UNKNOWN_SORT_BY = "Default";
    private List<SortPredicate.SortOptionItem> items = new ArrayList<SortPredicate.SortOptionItem>();
    @Self
    @Required
    private SlingHttpServletRequest request;
    @Self
    @Required
    private Options coreOptions;
    @Self
    @Optional
    private SearchConfig searchConfig;
    @ValueMapValue
    @Default(values={"Default"})
    private String unknownSortBy;
    @ValueMapValue
    @Default(values={"ASC"})
    private String ascendingLabel;
    @ValueMapValue
    @Default(values={"DESC"})
    private String descendingLabel;

    @PostConstruct
    protected void init() {
        this.initPredicate(this.request, (Field)this.coreOptions);
        this.populateOptionItems();
    }

    @Override
    public List<OptionItem> getItems() {
        ValueMap initialValues = this.getInitialValues();
        return this.items.stream().map(optionItem -> {
            boolean selected = PredicateUtil.isOptionInInitialValues(optionItem.getValue(), initialValues);
            optionItem.setSelected(selected);
            return optionItem;
        }).collect(Collectors.toList());
    }

    @Override
    public String getOrderByLabel() {
        String label = this.unknownSortBy;
        for (OptionItem optionItem : this.getItems()) {
            if (!optionItem.isSelected()) continue;
            label = optionItem.getText();
            break;
        }
        return label;
    }

    @Override
    public String getOrderBySortLabel() {
        if (this.isAscending()) {
            return this.ascendingLabel;
        }
        return this.descendingLabel;
    }

    @Override
    public boolean isAscending() {
        String orderBySort = (String)this.getInitialValues().get("sort", String.class);
        return "asc".equalsIgnoreCase(orderBySort);
    }

    public String getName() {
        return NAME_ORDER_BY;
    }

    @Override
    public boolean isReady() {
        return this.searchConfig != null && !this.getItems().isEmpty();
    }

    @Override
    public ValueMap getInitialValues() {
        if (this.valuesFromRequest == null) {
            this.valuesFromRequest = new ValueMapDecorator(new HashMap());
            String orderBy = PredicateUtil.getParamFromQueryParams(this.request, NAME_ORDER_BY);
            if (StringUtils.isBlank((CharSequence)orderBy)) {
                orderBy = this.searchConfig.getOrderBy();
            }
            this.valuesFromRequest.put((Object)NAME_ORDER_BY, (Object)orderBy);
            this.calculateOrderParameter("sort", this.searchConfig.getOrderBySort());
            this.calculateOrderParameter("case", this.searchConfig.isOrderByCase() ? "" : "ignore");
        }
        return this.valuesFromRequest;
    }

    private void calculateOrderParameter(String paramCase, String paramValue) {
        String orderParam = PredicateUtil.getParamFromQueryParams(this.request, "orderby." + paramCase);
        if (StringUtils.isBlank((CharSequence)orderParam)) {
            orderParam = paramValue;
        }
        this.valuesFromRequest.put((Object)paramCase, (Object)orderParam);
    }

    private void populateOptionItems() {
        Resource childItem = this.request.getResource().getChild(NN_ITEMS);
        if (childItem != null) {
            childItem.getChildren().forEach(this::addOption);
        }
    }

    private void addOption(Resource resource) {
        ValueMap properties = resource.getValueMap();
        SortOptionItem sortOptionItem = new SortOptionItem((String)properties.get(PN_TEXT, String.class), (String)properties.get(PN_VALUE, String.class), (Boolean)properties.get(PN_ORDER_BY_CASE, (Object)true));
        this.items.add(sortOptionItem);
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

