/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.structure.impl;

import com.adobe.aem.commons.assetshare.components.structure.Header;
import com.adobe.aem.commons.assetshare.components.structure.impl.NavigationItemImpl;
import com.adobe.cq.export.json.ComponentExporter;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.designer.Style;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Header.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/structure/header"})
@Exporter(name="jackson", extensions={"json"})
public class HeaderImpl
implements Header {
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/structure/header";
    private static final String DEFAULT_REL_PATH = "root/main/header";
    @ScriptVariable
    private Style currentStyle;
    @ScriptVariable
    private Page currentPage;
    @ScriptVariable
    private PageManager pageManager;
    private String relativeHeaderPath;
    private Resource headerResource;
    private ValueMap headerProperties;
    private List<Header.NavigationItem> items;
    private String rootPath;
    private String logoPath;
    private String siteTitle;

    @PostConstruct
    private void initModel() {
        this.relativeHeaderPath = (String)this.currentStyle.get("relPath", (Object)DEFAULT_REL_PATH);
        this.setHeaderResource();
    }

    private void setHeaderResource() {
        Page targetPage = this.currentPage;
        this.headerResource = targetPage.getContentResource(this.relativeHeaderPath);
        while (this.isEmptyHeader(this.headerResource) && targetPage != null) {
            if ((targetPage = targetPage.getParent()) == null) continue;
            this.headerResource = targetPage.getContentResource(this.relativeHeaderPath);
        }
        if (this.headerResource != null) {
            this.headerProperties = this.headerResource.getValueMap();
        }
    }

    private boolean isEmptyHeader(Resource headerResource) {
        if (headerResource != null) {
            String rootPathValue = (String)headerResource.getValueMap().get("rootPath", String.class);
            if (headerResource.hasChildren() || StringUtils.isNotBlank((CharSequence)rootPathValue)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Collection<Header.NavigationItem> getItems() {
        if (this.items == null) {
            this.items = this.createNavigationItems();
        }
        return new ArrayList<Header.NavigationItem>(this.items);
    }

    private List<Header.NavigationItem> createNavigationItems() {
        Resource pagesRes;
        ArrayList<Header.NavigationItem> navigationItems = new ArrayList<Header.NavigationItem>();
        if (this.headerResource != null && (pagesRes = this.headerResource.getChild("pages")) != null) {
            Iterator childResources = pagesRes.listChildren();
            while (childResources.hasNext()) {
                Header.NavigationItem navItem = this.createNavItem((Resource)childResources.next());
                if (navItem == null) continue;
                navigationItems.add(navItem);
            }
        }
        return navigationItems;
    }

    private Header.NavigationItem createNavItem(Resource resource) {
        ValueMap linkProperties = resource.getValueMap();
        String url = (String)linkProperties.get("path", String.class);
        String text = (String)linkProperties.get("text", String.class);
        boolean isActive = false;
        boolean isHierarchyActive = false;
        Page navPage = null;
        if (StringUtils.isNotBlank((CharSequence)url)) {
            if (url.startsWith("/content")) {
                navPage = this.pageManager.getPage(url);
                if (StringUtils.isBlank((CharSequence)text)) {
                    text = StringUtils.isNotBlank((CharSequence)navPage.getNavigationTitle()) ? navPage.getNavigationTitle() : navPage.getTitle();
                }
                isActive = this.currentPage.getPath().equals(url);
                isHierarchyActive = this.currentPage.getPath().startsWith(url);
            }
            NavigationItemImpl navItem = new NavigationItemImpl(navPage, isActive, isHierarchyActive, null, url, text);
            return navItem;
        }
        return null;
    }

    @Override
    public String getNavigationRoot() {
        if (this.rootPath == null) {
            this.rootPath = this.getHeaderProperty("rootPath");
        }
        return this.rootPath;
    }

    @Override
    public String getLogoPath() {
        if (this.logoPath == null) {
            this.logoPath = this.getHeaderProperty("logoPath");
        }
        return this.logoPath;
    }

    @Override
    public String getSiteTitle() {
        if (this.siteTitle == null) {
            this.siteTitle = this.getHeaderProperty("title");
        }
        if (this.siteTitle == null) {
            this.siteTitle = this.getHeaderProperty("jcr:title");
        }
        return this.siteTitle;
    }

    private String getHeaderProperty(String propertyName) {
        if (this.headerProperties == null) {
            return null;
        }
        return (String)this.headerProperties.get(propertyName, (Object)((String)this.currentStyle.get(propertyName, String.class)));
    }

    @Override
    public boolean isReady() {
        return this.getItems().size() > 0 || StringUtils.isNotBlank((CharSequence)this.getLogoPath()) || StringUtils.isNotBlank((CharSequence)this.getSiteTitle());
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

