/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.properties.impl;

import com.adobe.aem.commons.assetshare.content.properties.AbstractComputedProperty;
import com.adobe.aem.commons.assetshare.content.properties.ComputedProperty;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.UIHelper;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ComputedProperty.class}, property={"service.ranking=-1"})
@Designate(ocd=Cfg.class)
public class AssetTypeImpl
extends AbstractComputedProperty<String> {
    public static final String LABEL = "Asset Type";
    public static final String NAME = "type";
    public static final String IMAGE_LABEL = "IMAGE";
    public static final String DOCUMENT_LABEL = "DOCUMENT";
    public static final String VIDEO_LABEL = "VIDEO";
    public static final String AUDIO_LABEL = "AUDIO";
    public static final String UNKNOWN_LABEL = "";
    private static final String SERVICE_NAME = "mimetype-service";
    private static final String MIMETYPE_LOOKUP_RESOURCE_PATH = "/mnt/overlay/dam/gui/content/assets/jcr:content/mimeTypeLookup";
    private Cfg cfg;
    @Reference
    private transient ResourceResolverFactory resourceResolverFactory;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getLabel() {
        return this.cfg.label();
    }

    @Override
    public String[] getTypes() {
        return this.cfg.types();
    }

    @Override
    public String get(Asset asset) {
        String mimeType = (String)StringUtils.defaultIfBlank((CharSequence)asset.getMimeType(), (CharSequence)UNKNOWN_LABEL);
        String assetType = this.getAssetTypeFromMimetypeConfiguration(mimeType);
        if (StringUtils.isBlank((CharSequence)assetType)) {
            if (mimeType.startsWith("image")) {
                assetType = this.cfg.imageLabel();
            } else if (mimeType.startsWith("text")) {
                assetType = this.cfg.documentLabel();
            } else if (mimeType.startsWith("video")) {
                assetType = this.cfg.videoLabel();
            } else if (mimeType.startsWith("audio")) {
                assetType = this.cfg.audioLabel();
            } else if (mimeType.startsWith("application")) {
                int indexTwo;
                String ext = (String)StringUtils.defaultIfBlank((CharSequence)mimeType.substring(mimeType.lastIndexOf(47) + 1, mimeType.length()), (CharSequence)UNKNOWN_LABEL);
                int indexOne = ext.lastIndexOf(46);
                int lastWordIdx = indexOne > (indexTwo = ext.lastIndexOf(45)) ? indexOne : indexTwo;
                assetType = ext.substring(lastWordIdx + 1).toUpperCase();
            }
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)assetType, (CharSequence)this.cfg.unknownLabel());
    }

    private String getAssetTypeFromMimetypeConfiguration(String mimeType) {
        String string;
        block9: {
            String ext = (String)StringUtils.defaultIfBlank((CharSequence)mimeType.substring(mimeType.lastIndexOf(47) + 1, mimeType.length()), (CharSequence)UNKNOWN_LABEL);
            Map<String, String> authInfo = Collections.singletonMap("sling.service.subservice", SERVICE_NAME);
            ResourceResolver serviceResourceResolver = this.resourceResolverFactory.getServiceResourceResolver(authInfo);
            try {
                Resource lookedupResource = serviceResourceResolver.getResource(MIMETYPE_LOOKUP_RESOURCE_PATH);
                if (lookedupResource == null) {
                    throw new IllegalStateException("Service resource resolver " + serviceResourceResolver + " does not have access to system resource " + MIMETYPE_LOOKUP_RESOURCE_PATH);
                }
                string = UIHelper.lookupMimeType((String)ext, (Resource)lookedupResource, (boolean)true);
                if (serviceResourceResolver == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (serviceResourceResolver != null) {
                        try {
                            serviceResourceResolver.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LoginException e) {
                    throw new IllegalStateException("Service resource resolver with subservice name mimetype-service does not allow login", e);
                }
            }
            serviceResourceResolver.close();
        }
        return string;
    }

    @Activate
    protected void activate(Cfg cfg) {
        this.cfg = cfg;
    }

    @ObjectClassDefinition(name="Asset Share Commons - Computed Property - Asset Type")
    public static @interface Cfg {
        @AttributeDefinition(name="Label", description="Human read-able label.")
        public String label() default "Asset Type";

        @AttributeDefinition(name="Types", description="Defines the type of data this exposes. This classification allows for intelligent exposure of Computed Properties in DataSources, etc.")
        public String[] types() default {"metadata"};

        @AttributeDefinition(name="Image Label")
        public String imageLabel() default "IMAGE";

        @AttributeDefinition(name="Document Label")
        public String documentLabel() default "DOCUMENT";

        @AttributeDefinition(name="Video Label")
        public String videoLabel() default "VIDEO";

        @AttributeDefinition(name="Audio Label")
        public String audioLabel() default "AUDIO";

        @AttributeDefinition(name="Unknown Label", description="Defaults to blank so it can be trivially handled via HTL existence checks.")
        public String unknownLabel() default "";
    }
}

