/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.search.impl;

import com.adobe.aem.commons.assetshare.components.search.SearchConfig;
import com.adobe.aem.commons.assetshare.search.Search;
import com.adobe.aem.commons.assetshare.search.UnsafeSearchException;
import com.adobe.aem.commons.assetshare.search.providers.SearchProvider;
import com.adobe.aem.commons.assetshare.search.results.Results;
import com.adobe.aem.commons.assetshare.search.results.impl.results.EmptyResultsImpl;
import com.adobe.aem.commons.assetshare.util.PredicateUtil;
import com.day.cq.wcm.api.Page;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.ScriptVariable;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Search.class})
public class SearchImpl
implements Search {
    private static final Logger log = LoggerFactory.getLogger(SearchImpl.class);
    private static final String PN_MODE = "mode";
    private static final String PN_LAYOUT = "layout";
    private String DEFAULT_MODE = "search";
    private String DEFAULT_LAYOUT = "card";
    @OSGiService
    List<SearchProvider> searchProviders;
    @Self
    @Required
    private SlingHttpServletRequest request;
    @Self
    @Required
    private SearchConfig searchConfig;
    @ScriptVariable
    private Page currentPage;
    private Results results = null;
    private ValueMap properties;
    private Resource resource;

    @PostConstruct
    protected void init() {
        this.resource = this.searchConfig.getSearchResource();
        this.properties = this.request.getResource().getValueMap();
    }

    @Override
    public String getFormId() {
        return "asset-share__form";
    }

    @Override
    public Results getResults() {
        if (this.results == null) {
            for (SearchProvider searchProvider : this.searchProviders) {
                if (!searchProvider.accepts(this.request)) continue;
                try {
                    this.results = searchProvider.getResults(this.request);
                }
                catch (UnsafeSearchException e) {
                    log.warn("An unsafe search was initiated. Aborting with prejudice. Returning zero results.", (Throwable)e);
                    this.results = Results.ERRING_RESULTS;
                }
                catch (RepositoryException e) {
                    log.error("An issue occurred while executing the query. Returning zero results.", (Throwable)e);
                    this.results = Results.ERRING_RESULTS;
                }
                break;
            }
            if (this.results == null) {
                this.results = new EmptyResultsImpl();
            }
        }
        return this.results;
    }

    @Override
    public String getMode() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.searchConfig.getMode(), (CharSequence)((String)this.currentPage.getProperties().get(PN_MODE, (Object)this.DEFAULT_MODE)));
    }

    @Override
    public String getLayout() {
        String value = PredicateUtil.getParamFromQueryParams(this.request, PN_LAYOUT);
        return (String)StringUtils.defaultIfBlank((CharSequence)value, (CharSequence)this.searchConfig.getLayout());
    }
}

