/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public class ParameterUtil {
    private static final Logger log = LoggerFactory.getLogger(ParameterUtil.class);

    private ParameterUtil() {
    }

    public static Map.Entry<String, String> toMapEntryWithOptionalValue(String value, String separator) {
        return ParameterUtil.toSimpleEntry(value, separator, true);
    }

    public static Map.Entry<String, String> toMapEntry(String value, String separator) {
        return ParameterUtil.toSimpleEntry(value, separator, false);
    }

    private static AbstractMap.SimpleEntry<String, String> toSimpleEntry(String value, String separator, boolean isValueOptional) {
        String[] tmp = StringUtils.split((String)value, (String)separator, (int)2);
        if (tmp == null) {
            return null;
        }
        if (tmp.length == 2) {
            return new AbstractMap.SimpleEntry<String, String>(tmp[0], tmp[1]);
        }
        if (isValueOptional && tmp.length == 1) {
            return new AbstractMap.SimpleEntry<String, Object>(tmp[0], null);
        }
        return null;
    }

    public static Map<String, String> toMap(String[] values, String separator) {
        return ParameterUtil.toMap(values, separator, false, null);
    }

    public static Map<String, String> toMap(String[] values, String separator, boolean allowValuelessKeys, String defaultValue) {
        return ParameterUtil.toMap(values, separator, allowValuelessKeys, defaultValue, false);
    }

    public static Map<String, String> toMap(String[] values, String separator, boolean allowValuelessKeys, String defaultValue, boolean allowMultipleSeparators) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (values == null || values.length < 1) {
            return map;
        }
        for (String value : values) {
            String[] tmp = StringUtils.split((String)value, (String)separator, (int)(allowMultipleSeparators ? 2 : -1));
            if (tmp.length == 1 && allowValuelessKeys) {
                if (StringUtils.startsWith((String)value, (String)separator) || StringUtils.stripToNull((String)tmp[0]) == null) continue;
                map.put(StringUtils.trim((String)tmp[0]), StringUtils.trimToEmpty((String)defaultValue));
                continue;
            }
            if (tmp.length != 2 || StringUtils.stripToNull((String)tmp[0]) == null) continue;
            map.put(StringUtils.trim((String)tmp[0]), StringUtils.trimToEmpty((String)tmp[1]));
        }
        return map;
    }

    public static Map<String, String[]> toMap(String[] values, String mapSeparator, String listSeparator) {
        return ParameterUtil.toMap(values, mapSeparator, listSeparator, false, null);
    }

    public static Map<String, String[]> toMap(String[] values, String mapSeparator, String listSeparator, boolean allowValuelessKeys, String defaultValue) {
        Map<String, String> map = ParameterUtil.toMap(values, mapSeparator, allowValuelessKeys, defaultValue);
        LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result.put(entry.getKey(), StringUtils.split((String)entry.getValue(), (String)listSeparator));
        }
        return result;
    }

    public static List<Pattern> toPatterns(String[] values) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        if (values == null) {
            return patterns;
        }
        for (String value : values) {
            if (!StringUtils.isNotBlank((String)value)) continue;
            patterns.add(Pattern.compile(value));
        }
        return patterns;
    }
}

