/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.actions.impl;

import com.adobe.aem.commons.assetshare.components.actions.ActionHelper;
import com.adobe.aem.commons.assetshare.configuration.Config;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.day.cq.wcm.api.WCMMode;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.models.factory.ModelFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public final class ActionHelperImpl
implements ActionHelper {
    @Reference
    private ModelFactory modelFactory;

    @Override
    public final List<AssetModel> getAssetsFromQueryParameter(SlingHttpServletRequest request, String parameterName) {
        RequestParameter[] requestParameters = request.getRequestParameters(parameterName);
        if (requestParameters != null) {
            return Arrays.stream(requestParameters).filter(Objects::nonNull).map(RequestParameter::getString).filter(StringUtils::isNotBlank).map(path -> Text.unescape((String)path)).map(path -> request.getResourceResolver().getResource(path)).filter(Objects::nonNull).map(resource -> (AssetModel)this.modelFactory.getModelFromWrappedRequest(request, resource, AssetModel.class)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public final List<String> getAllowedValuesFromQueryParameter(SlingHttpServletRequest request, String parameterName, String[] allowedValues) {
        RequestParameter[] requestParameters;
        if (allowedValues != null && (requestParameters = request.getRequestParameters(parameterName)) != null) {
            return Arrays.stream(requestParameters).map(RequestParameter::getString).filter(renditionName -> allowedValues.length == 0 || ArrayUtils.contains((Object[])allowedValues, (Object)renditionName)).distinct().collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public final List<AssetModel> getPlaceholderAsset(SlingHttpServletRequest request) {
        Config config;
        AssetModel placeholder;
        ArrayList<AssetModel> assets = new ArrayList<AssetModel>();
        if (!WCMMode.DISABLED.equals((Object)WCMMode.fromRequest((ServletRequest)request)) && (placeholder = (config = (Config)request.adaptTo(Config.class)).getPlaceholderAsset()) != null) {
            assets.add(placeholder);
        }
        return assets;
    }
}

