/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.details.impl;

import com.adobe.aem.commons.assetshare.components.details.ActionButtons;
import com.adobe.aem.commons.assetshare.components.details.impl.AbstractEmptyTextComponent;
import com.adobe.aem.commons.assetshare.configuration.Config;
import com.adobe.cq.export.json.ComponentExporter;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={ActionButtons.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/details/action-buttons"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@Exporter(name="jackson", extensions={"json"})
public class ActionButtonsImpl
extends AbstractEmptyTextComponent
implements ActionButtons {
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/details/action-buttons";
    @Self
    @Required
    private SlingHttpServletRequest request;
    @ValueMapValue
    private String downloadLabel;
    @ValueMapValue
    private String addToCartLabel;
    @ValueMapValue
    private String removeFromCartLabel;
    @ValueMapValue
    private String shareLabel;

    @Override
    public boolean isEmpty() {
        return !this.isReady();
    }

    @Override
    public boolean isReady() {
        Config config = (Config)this.request.adaptTo(Config.class);
        if (config == null) {
            return false;
        }
        return this.isCartEnabled(config) || this.isDownloadEnabled(config) || this.isShareEnabled(config);
    }

    private boolean isCartEnabled(Config config) {
        return config.isCartEnabled() && StringUtils.isNotBlank((CharSequence)this.addToCartLabel) && StringUtils.isNotBlank((CharSequence)this.removeFromCartLabel);
    }

    private boolean isDownloadEnabled(Config config) {
        return config.isDownloadEnabled() && StringUtils.isNotBlank((CharSequence)this.downloadLabel);
    }

    private boolean isShareEnabled(Config config) {
        return config.isShareEnabled() && StringUtils.isNotBlank((CharSequence)this.shareLabel);
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

