/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.details.impl;

import com.adobe.aem.commons.assetshare.components.details.Renditions;
import com.adobe.aem.commons.assetshare.components.details.impl.AbstractEmptyTextComponent;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionDispatchers;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionParameters;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditions;
import com.adobe.aem.commons.assetshare.util.UrlUtil;
import com.adobe.cq.export.json.ComponentExporter;
import com.adobe.cq.wcm.core.components.models.form.OptionItem;
import com.adobe.cq.wcm.core.components.models.form.Options;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.UIHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.apache.sling.models.factory.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Renditions.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/details/renditions"})
@Exporter(name="jackson", extensions={"json"})
public class RenditionsImpl
extends AbstractEmptyTextComponent
implements Renditions {
    private static final Logger log = LoggerFactory.getLogger(RenditionsImpl.class);
    private static final String NN_ASSET_RENDITIONS_OPTIONS = "asset-renditions";
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/details/renditions";
    @Self
    @Required
    private SlingHttpServletRequest request;
    @Self
    @Required
    private AssetModel asset;
    @ValueMapValue
    @Default(booleanValues={false})
    private boolean allowLinks;
    @ValueMapValue
    @Default(booleanValues={false})
    private boolean showMissingRenditions;
    @OSGiService
    @Required
    private MimeTypeService mimeTypeService;
    @OSGiService
    @Required
    private AssetRenditions assetRenditions;
    @OSGiService
    @Required
    private AssetRenditionDispatchers assetRenditionDispatchers;
    @OSGiService
    @Required
    private ModelFactory modelFactory;
    @ValueMapValue
    @Optional
    private Boolean legacyMode;
    private Collection<com.adobe.aem.commons.assetshare.content.Rendition> renditions = null;
    @Deprecated
    private Options legacyRenditionOptions;
    private Options renditionOptions;

    @PostConstruct
    protected void init() {
        this.legacyRenditionOptions = (Options)this.request.adaptTo(Options.class);
        Resource assetRenditionsOptionsResource = this.request.getResource().getChild(NN_ASSET_RENDITIONS_OPTIONS);
        if (assetRenditionsOptionsResource != null) {
            this.renditionOptions = (Options)this.modelFactory.getModelFromWrappedRequest(this.request, assetRenditionsOptionsResource, Options.class);
        }
    }

    @Override
    public Collection<com.adobe.aem.commons.assetshare.content.Rendition> getRenditions() {
        if (this.isLegacyMode()) {
            return this.getLegacyRenditions(this.isShowMissingRenditions());
        }
        return this.getRenditions(this.isShowMissingRenditions());
    }

    @Override
    public boolean isAllowLinks() {
        return this.allowLinks;
    }

    @Override
    public boolean isShowMissingRenditions() {
        return this.showMissingRenditions;
    }

    @Deprecated
    private Collection<com.adobe.aem.commons.assetshare.content.Rendition> getRenditions(boolean includeAll) {
        if (this.renditions == null) {
            ArrayList<com.adobe.aem.commons.assetshare.content.Rendition> collectedRenditions = new ArrayList<com.adobe.aem.commons.assetshare.content.Rendition>();
            if (this.renditionOptions != null) {
                for (OptionItem item : this.renditionOptions.getItems()) {
                    AssetRenditionParameters parameters = new AssetRenditionParameters(this.asset, item.getValue(), true);
                    if (this.assetRenditionDispatchers.isValidAssetRenditionName(item.getValue())) {
                        collectedRenditions.add(new RenditionImpl(item.getText(), this.assetRenditions.getUrl(this.request, this.asset, parameters), StringUtils.isNotBlank((CharSequence)((CharSequence)this.asset.getProperties().get("license", String.class))), true));
                        continue;
                    }
                    if (!includeAll) continue;
                    collectedRenditions.add(new MissingRenditionImpl(item.getText()));
                }
            }
            this.renditions = collectedRenditions;
        }
        return new ArrayList<com.adobe.aem.commons.assetshare.content.Rendition>(this.renditions);
    }

    @Deprecated
    private Collection<com.adobe.aem.commons.assetshare.content.Rendition> getLegacyRenditions(boolean includeAll) {
        if (this.renditions == null) {
            ArrayList<com.adobe.aem.commons.assetshare.content.Rendition> collectedRenditions = new ArrayList<com.adobe.aem.commons.assetshare.content.Rendition>();
            List<Rendition> assetRenditions = this.asset.getRenditions();
            for (OptionItem item : this.legacyRenditionOptions.getItems()) {
                Pattern pattern = Pattern.compile(item.getValue());
                boolean found = false;
                for (Rendition assetRendition : assetRenditions) {
                    Matcher matcher = pattern.matcher(assetRendition.getName());
                    if (!matcher.matches()) continue;
                    collectedRenditions.add(new LegacyRenditionImpl(item.getText(), assetRendition, StringUtils.isNotBlank((CharSequence)((CharSequence)this.asset.getProperties().get("license", String.class))), true));
                    found = true;
                }
                if (found || !includeAll) continue;
                collectedRenditions.add(new MissingRenditionImpl(item.getText()));
            }
            this.renditions = collectedRenditions;
        }
        return new ArrayList<com.adobe.aem.commons.assetshare.content.Rendition>(this.renditions);
    }

    @Override
    public boolean isEmpty() {
        return this.getRenditions().size() == 0;
    }

    @Override
    public boolean isReady() {
        return !this.isEmpty();
    }

    private boolean isLegacyMode() {
        if (this.legacyMode == null) {
            if (this.renditionOptions != null && !this.renditionOptions.getItems().isEmpty()) {
                return false;
            }
            return this.legacyRenditionOptions != null && !this.legacyRenditionOptions.getItems().isEmpty();
        }
        return this.legacyMode;
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }

    private class MissingRenditionImpl
    implements com.adobe.aem.commons.assetshare.content.Rendition {
        private final String label;

        public MissingRenditionImpl(String text) {
            this.label = text;
        }

        @Override
        public boolean isExists() {
            return false;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String getSize() {
            return null;
        }

        @Override
        public String getMimeType() {
            return null;
        }

        @Override
        public String getPath() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String getDownloadFileName() {
            return this.getLabel();
        }

        @Override
        public boolean isLicensed() {
            return false;
        }
    }

    @Deprecated
    private class LegacyRenditionImpl
    implements com.adobe.aem.commons.assetshare.content.Rendition {
        private final String label;
        private final String size;
        private final String mimeType;
        private final String path;
        private final String name;
        private final boolean exists;
        private final boolean licensed;

        public LegacyRenditionImpl(String label, Rendition assetRendition, boolean licensed, boolean exists) {
            this.label = label;
            this.size = UIHelper.getSizeLabel((double)assetRendition.getSize());
            this.mimeType = assetRendition.getMimeType();
            this.path = UrlUtil.escape(assetRendition.getPath());
            this.name = assetRendition.getName();
            this.exists = exists;
            this.licensed = licensed;
        }

        @Override
        public String getDownloadFileName() {
            String downloadFileName = StringUtils.removeEnd((String)this.label, (String)".");
            String extension = RenditionsImpl.this.mimeTypeService.getExtension(this.mimeType);
            if (StringUtils.isBlank((CharSequence)extension) && StringUtils.equals((CharSequence)(extension = StringUtils.substringAfterLast((String)this.name, (String)".")), (CharSequence)this.name)) {
                extension = null;
            }
            if (extension != null) {
                downloadFileName = downloadFileName + "." + extension;
            }
            return downloadFileName;
        }

        @Override
        public boolean isExists() {
            return this.exists;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String getSize() {
            return this.size;
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isLicensed() {
            return this.licensed;
        }
    }

    private class RenditionImpl
    implements com.adobe.aem.commons.assetshare.content.Rendition {
        private final String label;
        private final String path;
        private final String name;
        private final boolean exists;
        private final boolean licensed;

        public RenditionImpl(String label, String url, boolean licensed, boolean exists) {
            this.label = label;
            this.path = UrlUtil.escape(url);
            this.name = label;
            this.exists = exists;
            this.licensed = licensed;
        }

        @Override
        public String getDownloadFileName() {
            return "";
        }

        @Override
        public boolean isExists() {
            return this.exists;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String getSize() {
            return "";
        }

        @Override
        public String getMimeType() {
            return null;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isLicensed() {
            return this.licensed;
        }
    }
}

