/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.details.impl;

import com.adobe.aem.commons.assetshare.components.details.Video;
import com.adobe.aem.commons.assetshare.components.details.impl.AbstractEmptyTextComponent;
import com.adobe.aem.commons.assetshare.content.AssetModel;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditionParameters;
import com.adobe.aem.commons.assetshare.content.renditions.AssetRenditions;
import com.adobe.aem.commons.assetshare.util.UrlUtil;
import com.adobe.cq.export.json.ComponentExporter;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={Video.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/details/video"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@Exporter(name="jackson", extensions={"json"})
public class VideoImpl
extends AbstractEmptyTextComponent
implements Video {
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/details/video";
    @Self
    @Required
    private SlingHttpServletRequest request;
    @Self
    @Required
    private AssetModel asset;
    @OSGiService
    @Required
    private AssetRenditions assetRenditions;
    @Deprecated
    @ValueMapValue
    private String computedProperty;
    @Deprecated
    @ValueMapValue
    private String renditionRegex;
    @ValueMapValue
    private Boolean legacyMode;
    @ValueMapValue
    private String renditionName;
    private ValueMap combinedProperties;
    private String src = null;

    @PostConstruct
    public void init() {
        if (this.asset != null) {
            this.combinedProperties = this.asset.getProperties();
        }
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.getSrc());
    }

    @Override
    public boolean isReady() {
        return !this.isEmpty();
    }

    @Override
    public String getSrc() {
        if (this.src == null) {
            String tmp = null;
            if (!this.isLegacyMode()) {
                if (this.asset != null && StringUtils.isNotBlank((CharSequence)this.renditionName)) {
                    AssetRenditionParameters parameters = new AssetRenditionParameters(this.asset, this.renditionName, false);
                    tmp = this.assetRenditions.getUrl(this.request, this.asset, parameters);
                }
            } else {
                tmp = this.getLegacySrc();
            }
            this.src = UrlUtil.escape(tmp);
        }
        return this.src;
    }

    @Deprecated
    private String getLegacySrc() {
        String src = (String)this.combinedProperties.get(this.computedProperty, String.class);
        if (StringUtils.isBlank((CharSequence)src) && StringUtils.isNotBlank((CharSequence)this.renditionRegex)) {
            this.fetchSrcFromRegex();
        }
        return src;
    }

    @Deprecated
    private void fetchSrcFromRegex() {
        Pattern pattern = Pattern.compile(this.renditionRegex);
        for (Rendition rendition : this.asset.getRenditions()) {
            if ("video/x-flv".equalsIgnoreCase(rendition.getMimeType()) || !pattern.matcher(rendition.getName()).matches()) continue;
            this.src = rendition.getPath();
            break;
        }
    }

    @Override
    public boolean isVideoAsset() {
        if (null != this.asset && null != this.asset.getResource()) {
            return DamUtil.isVideo((Asset)((Asset)this.asset.getResource().adaptTo(Asset.class)));
        }
        return false;
    }

    protected boolean isLegacyMode() {
        if (this.legacyMode == null) {
            if (StringUtils.isNotBlank((CharSequence)this.renditionName)) {
                return false;
            }
            return StringUtils.isNotBlank((CharSequence)this.computedProperty) || StringUtils.isNotBlank((CharSequence)this.renditionRegex);
        }
        return this.legacyMode;
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

