/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.predicates.impl;

import com.adobe.aem.commons.assetshare.components.predicates.AbstractPredicate;
import com.adobe.aem.commons.assetshare.components.predicates.FreeformTextPredicate;
import com.adobe.aem.commons.assetshare.util.PredicateUtil;
import com.adobe.cq.export.json.ComponentExporter;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={FreeformTextPredicate.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/search/freeform-text"}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
@Exporter(name="jackson", extensions={"json"})
public class FreeformTextPredicatePredicateImpl
extends AbstractPredicate
implements FreeformTextPredicate {
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/search/freeform-text";
    private static final String CUSTOM_DELIMITER = "__CUSTOM_DELIMITER";
    private static final String PN_DELIMITER_VALUE = "value";
    private static final String PN_DELIMITER_CUSTOM_VALUE = "customValue";
    private static final String NN_DELIMITERS = "delimiters";
    private static final String OP_STARTS_WITH = "startsWith";
    @Self
    @Required
    private SlingHttpServletRequest request;
    @ValueMapValue
    @Named(value="jcr:title")
    private String title;
    @ValueMapValue
    private String property;
    @ValueMapValue
    private String operation;
    @ValueMapValue
    private String placeholder;
    @ValueMapValue
    private Integer inputValidationMinLength;
    @ValueMapValue
    private Integer inputValidationMaxLength;
    @ValueMapValue
    private String inputValidationPattern;
    @ValueMapValue
    private String inputValidationMessage;
    @ValueMapValue
    @Default(intValues={1})
    private int rows;
    @ValueMapValue(name="type")
    private String typeString;
    protected List<String> delimiters = null;
    protected String valueFromRequest = null;
    protected ValueMap valuesFromRequest = null;

    @PostConstruct
    protected void init() {
        super.initGroup(this.request);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getPlaceholder() {
        return this.placeholder;
    }

    public String getName() {
        return "propertyvalues";
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    public boolean hasOperation() {
        return StringUtils.isNotBlank((CharSequence)this.getOperation());
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public Integer getInputValidationMinLength() {
        if (StringUtils.equals((CharSequence)OP_STARTS_WITH, (CharSequence)this.getOperation()) && (this.inputValidationMinLength == null || this.inputValidationMinLength < 3)) {
            return 3;
        }
        return this.inputValidationMinLength;
    }

    @Override
    public Integer getInputValidationMaxLength() {
        return this.inputValidationMaxLength;
    }

    @Override
    public String getInputValidationPattern() {
        return StringUtils.stripToNull((String)this.inputValidationPattern);
    }

    @Override
    public String getInputValidationMessage() {
        return StringUtils.stripToNull((String)this.inputValidationMessage);
    }

    @Override
    public List<String> getDelimiters() {
        if (this.delimiters == null) {
            Resource delimitersResource = this.request.getResource().getChild(NN_DELIMITERS);
            if (delimitersResource == null) {
                return Collections.EMPTY_LIST;
            }
            this.delimiters = StreamSupport.stream(delimitersResource.getChildren().spliterator(), false).map(option -> {
                ValueMap properties = option.getValueMap();
                String value = (String)properties.get(PN_DELIMITER_VALUE, String.class);
                String customValue = (String)properties.get(PN_DELIMITER_CUSTOM_VALUE, String.class);
                if (CUSTOM_DELIMITER.equals(value)) {
                    return customValue;
                }
                return value;
            }).collect(Collectors.toList());
        }
        return this.delimiters;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public String getInitialValue() {
        if (this.valueFromRequest == null) {
            this.valueFromRequest = PredicateUtil.getInitialValue(this.request, this, "values");
        }
        return this.valueFromRequest;
    }

    @Override
    public ValueMap getInitialValues() {
        if (this.valuesFromRequest == null) {
            this.valuesFromRequest = PredicateUtil.getInitialValues(this.request, this, "values");
        }
        return this.valuesFromRequest;
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

