/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.predicates.impl;

import com.adobe.aem.commons.assetshare.components.predicates.AbstractPredicate;
import com.adobe.aem.commons.assetshare.components.predicates.HiddenPredicate;
import com.adobe.cq.export.json.ComponentExporter;
import com.day.cq.search.PredicateConverter;
import com.day.cq.search.PredicateGroup;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.factory.ModelFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={HiddenPredicate.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/search/hidden"})
@Exporter(name="jackson", extensions={"json"})
public class HiddenPredicateImpl
extends AbstractPredicate
implements HiddenPredicate {
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/search/hidden";
    private static final String NN_PREDICATES = "predicates";
    private static final String PN_PREDICATE = "predicate";
    private static final String PN_VALUE = "value";
    @Self
    @Required
    private SlingHttpServletRequest request;
    @SlingObject
    @Required
    private Resource resource;
    @OSGiService
    private ModelFactory modelFactory;

    @Override
    public boolean isReady() {
        return false;
    }

    @Override
    public PredicateGroup getPredicateGroup() {
        PredicateGroup hiddenPredicateGroup = new PredicateGroup("hiddenPredicate");
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.resource == null) {
            return hiddenPredicateGroup;
        }
        Resource predicates = this.resource.getChild(NN_PREDICATES);
        if (predicates == null) {
            return hiddenPredicateGroup;
        }
        Iterator iterator = predicates.listChildren();
        while (iterator.hasNext()) {
            Resource predicateResource = (Resource)iterator.next();
            ValueMap predicateProperties = predicateResource.getValueMap();
            String predicate = (String)predicateProperties.get(PN_PREDICATE, String.class);
            String value = (String)predicateProperties.get(PN_VALUE, (Object)"");
            if (!StringUtils.isNotBlank((CharSequence)predicate)) continue;
            params.put(predicate, value);
        }
        hiddenPredicateGroup.addAll((Collection)PredicateConverter.createPredicates(params));
        return hiddenPredicateGroup;
    }

    @Override
    public String getGroup() {
        throw new UnsupportedOperationException("Hidden predicate groupIds are managed in the PagePredicateImpl automatically");
    }

    public String getName() {
        throw new UnsupportedOperationException("Hidden predicates have no name");
    }

    @Override
    @Deprecated
    public Map<String, String> getParams(int groupId) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.resource == null) {
            return params;
        }
        Resource predicates = this.resource.getChild(NN_PREDICATES);
        if (predicates == null) {
            return params;
        }
        Iterator iterator = predicates.listChildren();
        while (iterator.hasNext()) {
            Resource predicateResource = (Resource)iterator.next();
            ValueMap predicateProperties = predicateResource.getValueMap();
            String predicate = (String)predicateProperties.get(PN_PREDICATE, String.class);
            String value = (String)predicateProperties.get(PN_VALUE, (Object)"");
            if (!StringUtils.isNotBlank((CharSequence)predicate)) continue;
            params.put(groupId + "_group." + predicate, value);
        }
        return params;
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

