/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.components.structure.impl;

import com.adobe.aem.commons.assetshare.components.structure.UserMenu;
import com.adobe.cq.export.json.ComponentExporter;
import com.day.cq.wcm.api.designer.Style;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Exporter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Required;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={UserMenu.class, ComponentExporter.class}, resourceType={"asset-share-commons/components/structure/user-menu"})
@Exporter(name="jackson", extensions={"json"})
public class UserMenuImpl
implements UserMenu {
    private static final Logger log = LoggerFactory.getLogger(UserMenuImpl.class);
    protected static final String RESOURCE_TYPE = "asset-share-commons/components/structure/user-menu";
    private static final String PROFILE_PATH_SUFFIX = "/primary/image.prof.thumbnail.48.48.png";
    private static final String ANONYMOUS = "anonymous";
    private static final String NN_PROFILE = "profile";
    private static final String PN_LOG_IN_LABEL = "logInLabel";
    private static final String PN_LOG_IN_LINK = "logInLink";
    private static final String PN_LOG_OUT_LABEL = "logOutLabel";
    private static final String PN_LOG_OUT_LINK = "logOutLink";
    @Self
    @Required
    private SlingHttpServletRequest request;
    @Inject
    @Required
    private Style currentStyle;

    @Override
    public boolean isReady() {
        String logInLabel = (String)this.currentStyle.get(PN_LOG_IN_LABEL, String.class);
        String logInLink = (String)this.currentStyle.get(PN_LOG_IN_LINK, String.class);
        String logOutLabel = (String)this.currentStyle.get(PN_LOG_OUT_LABEL, String.class);
        String logOutLink = (String)this.currentStyle.get(PN_LOG_OUT_LINK, String.class);
        return StringUtils.isNotEmpty((CharSequence)logInLabel) && StringUtils.isNotEmpty((CharSequence)logInLink) && StringUtils.isNotEmpty((CharSequence)logOutLabel) && StringUtils.isNotEmpty((CharSequence)logOutLink);
    }

    @Nonnull
    public String getExportedType() {
        return RESOURCE_TYPE;
    }
}

