/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.configuration.impl.datasources;

import com.adobe.aem.commons.assetshare.util.DataSourceBuilder;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=asset-share-commons/data-sources/result-resource-types", "sling.servlet.methods=GET"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class SearchResultsResourceTypeDataSource
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(SearchResultsResourceTypeDataSource.class);
    @Reference
    private transient QueryBuilder queryBuilder;
    @Reference
    private transient DataSourceBuilder dataSourceBuilder;

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        ValueMap properties = request.getResource().getValueMap();
        String[] extensionTypes = (String[])properties.get("extensionTypes", (Object)new String[0]);
        String[] resourceTypes = (String[])properties.get("resourceTypes", (Object)new String[0]);
        String[] resourceSuperTypes = (String[])properties.get("resourceSuperTypes", (Object)new String[0]);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", "cq:Component");
        params.put("path", "/apps");
        params.put("group.p.or", "true");
        int index = 1;
        if (extensionTypes.length > 0) {
            params.put("group.2_property", "extensionType");
            for (String extensionType : extensionTypes) {
                params.put("group.2_property." + index++ + "_value", extensionType);
            }
        }
        if (resourceTypes.length > 0) {
            params.put("group.2_property", "sling:resourceType");
            for (String resourceType : resourceTypes) {
                params.put("group.2_property." + index++ + "_value", resourceType);
            }
        }
        if (resourceSuperTypes.length > 0) {
            params.put("group.3_property", "sling:resourceSuperType");
            for (String resourceSuperType : resourceSuperTypes) {
                params.put("group.3_property." + index++ + "_value", resourceSuperType);
            }
        }
        Query query = this.queryBuilder.createQuery(PredicateGroup.create(params), (Session)request.getResourceResolver().adaptTo(Session.class));
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        for (Hit hit : query.getResult().getHits()) {
            try {
                data.put((String)hit.getProperties().get("jcr:title", (Object)hit.getTitle()), hit.getPath());
            }
            catch (RepositoryException e) {
                log.error("Could not collect Search Results ResourceType for data source.");
            }
        }
        this.dataSourceBuilder.build(request, data);
    }
}

