/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.commons.assetshare.content.renditions;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetRendition {
    private static final Logger log = LoggerFactory.getLogger(AssetRendition.class);
    public static final AssetRendition UNAVAILABLE_ASSET_RENDITION = new AssetRendition(URI.create("failed://to.resolve.asset.rendition"), (Long)0L, "unavailable/unavailable");
    private URI binaryUri;
    private Optional<Long> size;
    private String mimeType;

    public AssetRendition(URI uri, Long size, String mimeType) {
        this(uri.toString(), size, mimeType);
    }

    public AssetRendition(String uri, Long size, String mimeType) {
        URI cleanURI = null;
        try {
            cleanURI = this.cleanURI(uri.toString());
        }
        catch (URISyntaxException e) {
            log.warn("Unable to clean the URI [ {} ], using it as is.", (Object)uri, (Object)e);
            cleanURI = URI.create(uri);
        }
        this.setBinaryUri(cleanURI);
        this.setSize(size);
        this.setMimeType(mimeType);
    }

    public URI getBinaryUri() {
        return this.binaryUri;
    }

    public void setBinaryUri(URI binaryUri) {
        this.binaryUri = binaryUri;
    }

    public Optional<Long> getSize() {
        if (this.size != null) {
            return this.size;
        }
        return Optional.empty();
    }

    public void setSize(Long size) {
        if (size != null) {
            this.size = Optional.of(size);
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    private URI cleanURI(String uri) throws URISyntaxException {
        uri = StringUtils.replace((String)uri, (String)" ", (String)"%20");
        uri = StringUtils.replace((String)uri, (String)"/_jcr_content", (String)"/jcr:content");
        return new URI(uri);
    }
}

